/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class LocalPropertiesFilteringTest {
    private TupleTypeInfo<Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>> tupleInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test
    public void testAllErased1() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{0, 1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{3, 4}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{5, 6}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        Assert.assertNull((Object)filtered.getGroupedFields());
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testAllErased2() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"5"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{0, 1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{3, 4}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        Assert.assertNull((Object)filtered.getGroupedFields());
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testGroupingPreserved1() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;2;3"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{0, 2, 3}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        Assert.assertNotNull((Object)filtered.getGroupedFields());
        Assert.assertEquals((long)3L, (long)filtered.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(3)));
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testGroupingPreserved2() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0->4;2->0;3->7"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{0, 2, 3}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        Assert.assertNotNull((Object)filtered.getGroupedFields());
        Assert.assertEquals((long)3L, (long)filtered.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(7)));
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testGroupingErased() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0->4;2->0"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{0, 2, 3}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        Assert.assertNull((Object)filtered.getGroupedFields());
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testSortingPreserved1() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;2;5"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(2), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(0), StringValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        LocalProperties lProps = LocalProperties.forOrdering((Ordering)o);
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldList gFields = filtered.getGroupedFields();
        Ordering order = filtered.getOrdering();
        Assert.assertNotNull((Object)gFields);
        Assert.assertEquals((long)3L, (long)gFields.size());
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(5)));
        Assert.assertNotNull((Object)order);
        Assert.assertEquals((long)3L, (long)order.getNumberOfFields());
        Assert.assertEquals((long)2L, (long)order.getFieldNumber(0).intValue());
        Assert.assertEquals((long)0L, (long)order.getFieldNumber(1).intValue());
        Assert.assertEquals((long)5L, (long)order.getFieldNumber(2).intValue());
        Assert.assertEquals((Object)Order.ASCENDING, (Object)order.getOrder(0));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)order.getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)order.getOrder(2));
        Assert.assertEquals(IntValue.class, (Object)order.getType(0));
        Assert.assertEquals(StringValue.class, (Object)order.getType(1));
        Assert.assertEquals(LongValue.class, (Object)order.getType(2));
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testSortingPreserved2() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0->3;2->7;5->1"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(2), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(0), StringValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        LocalProperties lProps = LocalProperties.forOrdering((Ordering)o);
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldList gFields = filtered.getGroupedFields();
        Ordering order = filtered.getOrdering();
        Assert.assertNotNull((Object)gFields);
        Assert.assertEquals((long)3L, (long)gFields.size());
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(7)));
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(1)));
        Assert.assertNotNull((Object)order);
        Assert.assertEquals((long)3L, (long)order.getNumberOfFields());
        Assert.assertEquals((long)7L, (long)order.getFieldNumber(0).intValue());
        Assert.assertEquals((long)3L, (long)order.getFieldNumber(1).intValue());
        Assert.assertEquals((long)1L, (long)order.getFieldNumber(2).intValue());
        Assert.assertEquals((Object)Order.ASCENDING, (Object)order.getOrder(0));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)order.getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)order.getOrder(2));
        Assert.assertEquals(IntValue.class, (Object)order.getType(0));
        Assert.assertEquals(StringValue.class, (Object)order.getType(1));
        Assert.assertEquals(LongValue.class, (Object)order.getType(2));
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testSortingPreserved3() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;2"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(2), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(0), StringValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        LocalProperties lProps = LocalProperties.forOrdering((Ordering)o);
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldList gFields = filtered.getGroupedFields();
        Ordering order = filtered.getOrdering();
        Assert.assertNotNull((Object)gFields);
        Assert.assertEquals((long)2L, (long)gFields.size());
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(2)));
        Assert.assertNotNull((Object)order);
        Assert.assertEquals((long)2L, (long)order.getNumberOfFields());
        Assert.assertEquals((long)2L, (long)order.getFieldNumber(0).intValue());
        Assert.assertEquals((long)0L, (long)order.getFieldNumber(1).intValue());
        Assert.assertEquals((Object)Order.ASCENDING, (Object)order.getOrder(0));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)order.getOrder(1));
        Assert.assertEquals(IntValue.class, (Object)order.getType(0));
        Assert.assertEquals(StringValue.class, (Object)order.getType(1));
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testSortingPreserved4() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"2->7;5"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(2), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(0), StringValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        LocalProperties lProps = LocalProperties.forOrdering((Ordering)o);
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldList gFields = filtered.getGroupedFields();
        Ordering order = filtered.getOrdering();
        Assert.assertNotNull((Object)gFields);
        Assert.assertEquals((long)1L, (long)gFields.size());
        Assert.assertTrue((boolean)gFields.contains(Integer.valueOf(7)));
        Assert.assertNotNull((Object)order);
        Assert.assertEquals((long)1L, (long)order.getNumberOfFields());
        Assert.assertEquals((long)7L, (long)order.getFieldNumber(0).intValue());
        Assert.assertEquals((Object)Order.ASCENDING, (Object)order.getOrder(0));
        Assert.assertEquals(IntValue.class, (Object)order.getType(0));
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testSortingErased() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;5"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(2), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(0), StringValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        LocalProperties lProps = LocalProperties.forOrdering((Ordering)o);
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldList gFields = filtered.getGroupedFields();
        Ordering order = filtered.getOrdering();
        Assert.assertNull((Object)gFields);
        Assert.assertNull((Object)order);
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test
    public void testUniqueFieldsPreserved1() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;1;2;3;4"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = new LocalProperties();
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{0, 1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{3, 4}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{4, 5, 6}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldSet expected1 = new FieldSet(new int[]{0, 1, 2});
        FieldSet expected2 = new FieldSet(new int[]{3, 4});
        Assert.assertNull((Object)filtered.getGroupedFields());
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNotNull((Object)filtered.getUniqueFields());
        Assert.assertEquals((long)2L, (long)filtered.getUniqueFields().size());
        Assert.assertTrue((boolean)filtered.getUniqueFields().contains(expected1));
        Assert.assertTrue((boolean)filtered.getUniqueFields().contains(expected2));
    }

    @Test
    public void testUniqueFieldsPreserved2() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;1;2;3;4"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{0, 1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{3, 4}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{4, 5, 6}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldSet expected1 = new FieldSet(new int[]{0, 1, 2});
        FieldSet expected2 = new FieldSet(new int[]{3, 4});
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNotNull((Object)filtered.getGroupedFields());
        Assert.assertEquals((long)2L, (long)filtered.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(2)));
        Assert.assertNotNull((Object)filtered.getUniqueFields());
        Assert.assertEquals((long)2L, (long)filtered.getUniqueFields().size());
        Assert.assertTrue((boolean)filtered.getUniqueFields().contains(expected1));
        Assert.assertTrue((boolean)filtered.getUniqueFields().contains(expected2));
    }

    @Test
    public void testUniqueFieldsPreserved3() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0->7;1->6;2->5;3->4;4->3"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = new LocalProperties();
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{0, 1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{3, 4}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{4, 5, 6}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        FieldSet expected1 = new FieldSet(new int[]{5, 6, 7});
        FieldSet expected2 = new FieldSet(new int[]{3, 4});
        Assert.assertNull((Object)filtered.getGroupedFields());
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNotNull((Object)filtered.getUniqueFields());
        Assert.assertEquals((long)2L, (long)filtered.getUniqueFields().size());
        Assert.assertTrue((boolean)filtered.getUniqueFields().contains(expected1));
        Assert.assertTrue((boolean)filtered.getUniqueFields().contains(expected2));
    }

    @Test
    public void testUniqueFieldsErased() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])new String[]{"0;1;4"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lProps = new LocalProperties();
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{0, 1, 2}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{3, 4}));
        lProps = lProps.addUniqueFields(new FieldSet(new int[]{4, 5, 6}));
        LocalProperties filtered = lProps.filterBySemanticProperties((SemanticProperties)sp, 0);
        Assert.assertNull((Object)filtered.getGroupedFields());
        Assert.assertNull((Object)filtered.getOrdering());
        Assert.assertNull((Object)filtered.getUniqueFields());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInvalidInputIndex() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1"}, null, null, this.tupleInfo, this.tupleInfo);
        LocalProperties lprops = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{0, 1}));
        lprops.filterBySemanticProperties((SemanticProperties)sprops, 1);
    }
}

