/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.MockPartitioner;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.junit.Assert;
import org.junit.Test;

public class GlobalPropertiesPushdownTest {
    @Test
    public void testAnyPartitioningPushedDown() {
        try {
            RequestedGlobalProperties req = new RequestedGlobalProperties();
            req.setAnyPartitioning(new FieldSet(new int[]{3, 1}));
            RequestedGlobalProperties preserved = req.filterBySemanticProperties(GlobalPropertiesPushdownTest.getAllPreservingSemProps(), 0);
            Assert.assertEquals((Object)PartitioningProperty.ANY_PARTITIONING, (Object)preserved.getPartitioning());
            Assert.assertTrue((boolean)preserved.getPartitionedFields().isValidSubset(new FieldSet(new int[]{1, 3})));
            RequestedGlobalProperties nonPreserved = req.filterBySemanticProperties(GlobalPropertiesPushdownTest.getNonePreservingSemProps(), 0);
            Assert.assertTrue((nonPreserved == null || nonPreserved.isTrivial() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testHashPartitioningPushedDown() {
        try {
            RequestedGlobalProperties req = new RequestedGlobalProperties();
            req.setHashPartitioned(new FieldSet(new int[]{3, 1}));
            RequestedGlobalProperties preserved = req.filterBySemanticProperties(GlobalPropertiesPushdownTest.getAllPreservingSemProps(), 0);
            Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)preserved.getPartitioning());
            Assert.assertTrue((boolean)preserved.getPartitionedFields().isValidSubset(new FieldSet(new int[]{1, 3})));
            RequestedGlobalProperties nonPreserved = req.filterBySemanticProperties(GlobalPropertiesPushdownTest.getNonePreservingSemProps(), 0);
            Assert.assertTrue((nonPreserved == null || nonPreserved.isTrivial() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningNotPushedDown() {
        try {
            RequestedGlobalProperties req = new RequestedGlobalProperties();
            req.setCustomPartitioned(new FieldSet(new int[]{3, 1}), (Partitioner)new MockPartitioner());
            RequestedGlobalProperties pushedDown = req.filterBySemanticProperties(GlobalPropertiesPushdownTest.getAllPreservingSemProps(), 0);
            Assert.assertTrue((pushedDown == null || pushedDown.isTrivial() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testForcedReblancingNotPushedDown() {
        try {
            RequestedGlobalProperties req = new RequestedGlobalProperties();
            req.setForceRebalancing();
            RequestedGlobalProperties pushedDown = req.filterBySemanticProperties(GlobalPropertiesPushdownTest.getAllPreservingSemProps(), 0);
            Assert.assertTrue((pushedDown == null || pushedDown.isTrivial() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static SemanticProperties getAllPreservingSemProps() {
        return new SingleInputSemanticProperties.AllFieldsForwardedProperties();
    }

    private static SemanticProperties getNonePreservingSemProps() {
        return new SingleInputSemanticProperties();
    }
}

