/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataexchange;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.junit.Assert;
import org.junit.Test;

public class DataExchangeModeOpenBranchingTest
extends CompilerTestBase {
    @Test
    public void testPipelinedForced() {
        this.verifyBranchigPlan(ExecutionMode.PIPELINED_FORCED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED);
    }

    @Test
    public void testPipelined() {
        this.verifyBranchigPlan(ExecutionMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED);
    }

    @Test
    public void testBatch() {
        this.verifyBranchigPlan(ExecutionMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED);
    }

    @Test
    public void testBatchForced() {
        this.verifyBranchigPlan(ExecutionMode.BATCH_FORCED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH);
    }

    private void verifyBranchigPlan(ExecutionMode execMode, DataExchangeMode toMap, DataExchangeMode toFilter, DataExchangeMode toFilterSink, DataExchangeMode toJoin1, DataExchangeMode toJoin2, DataExchangeMode toJoinSink, DataExchangeMode toDirectSink) {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.getConfig().setExecutionMode(execMode);
            MapOperator data = env.generateSequence(1L, 100000L).map((MapFunction)new MapFunction<Long, Tuple2<Long, Long>>(){

                public Tuple2<Long, Long> map(Long value) {
                    return new Tuple2((Object)value, (Object)value);
                }
            });
            data.filter((FilterFunction)new FilterFunction<Tuple2<Long, Long>>(){

                public boolean filter(Tuple2<Long, Long> value) {
                    return false;
                }
            }).output((OutputFormat)new DiscardingOutputFormat()).name("sink1");
            data.join((DataSet)env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1L, (Object)2L)})).where(new int[]{1}).equalTo(new int[]{0}).output((OutputFormat)new DiscardingOutputFormat()).name("sink2");
            data.output((OutputFormat)new DiscardingOutputFormat()).name("sink3");
            OptimizedPlan optPlan = this.compileNoStats((Plan)env.createProgramPlan());
            SinkPlanNode filterSink = this.findSink(optPlan.getDataSinks(), "sink1");
            SinkPlanNode joinSink = this.findSink(optPlan.getDataSinks(), "sink2");
            SinkPlanNode directSink = this.findSink(optPlan.getDataSinks(), "sink3");
            SingleInputPlanNode filterNode = (SingleInputPlanNode)filterSink.getPredecessor();
            SingleInputPlanNode mapNode = (SingleInputPlanNode)filterNode.getPredecessor();
            DualInputPlanNode joinNode = (DualInputPlanNode)joinSink.getPredecessor();
            Assert.assertEquals((Object)mapNode, (Object)joinNode.getInput1().getSource());
            Assert.assertEquals((Object)mapNode, (Object)directSink.getPredecessor());
            Assert.assertEquals((Object)toFilterSink, (Object)filterSink.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toJoinSink, (Object)joinSink.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toDirectSink, (Object)directSink.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toMap, (Object)mapNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toFilter, (Object)filterNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toJoin1, (Object)joinNode.getInput1().getDataExchangeMode());
            Assert.assertEquals((Object)toJoin2, (Object)joinNode.getInput2().getDataExchangeMode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private SinkPlanNode findSink(Collection<SinkPlanNode> collection, String name) {
        for (SinkPlanNode node : collection) {
            String nodeName = node.getOptimizerNode().getOperator().getName();
            if (nodeName == null || !nodeName.equals(name)) continue;
            return node;
        }
        throw new IllegalArgumentException("No node with that name was found.");
    }
}

