/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.MapPartitionOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dag.MapPartitionNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MapPartitionNodeTest {
    @Test
    public void testGetSemanticProperties() {
        SingleInputSemanticProperties origProps = new SingleInputSemanticProperties();
        origProps.addForwardedField(0, 1);
        origProps.addForwardedField(2, 2);
        origProps.addReadFields(new FieldSet(new int[]{0, 2, 4, 7}));
        MapPartitionOperatorBase op = (MapPartitionOperatorBase)Mockito.mock(MapPartitionOperatorBase.class);
        Mockito.when((Object)op.getSemanticProperties()).thenReturn((Object)origProps);
        Mockito.when((Object)op.getKeyColumns(0)).thenReturn((Object)new int[0]);
        MapPartitionNode node = new MapPartitionNode((SingleInputOperator)op);
        SemanticProperties filteredProps = node.getSemanticPropertiesForLocalPropertyFiltering();
        Assert.assertTrue((filteredProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(0, 1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(0, 2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getReadFields(0).size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(7)));
    }
}

