/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.custompartition;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.testfunctions.DummyCoGroupFunction;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class BinaryCustomPartitioningCompatibilityTest
extends CompilerTestBase {
    @Test
    public void testCompatiblePartitioningJoin() {
        try {
            Partitioner<Long> partitioner = new Partitioner<Long>(){

                public int partition(Long key, int numPartitions) {
                    return 0;
                }
            };
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            input1.partitionCustom((Partitioner)partitioner, 1).join((DataSet)input2.partitionCustom((Partitioner)partitioner, 0)).where(new int[]{1}).equalTo(new int[]{0}).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            DualInputPlanNode join = (DualInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode partitioner1 = (SingleInputPlanNode)join.getInput1().getSource();
            SingleInputPlanNode partitioner2 = (SingleInputPlanNode)join.getInput2().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)join.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)join.getInput2().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)partitioner1.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)partitioner2.getInput().getShipStrategy());
            Assert.assertEquals((Object)partitioner, (Object)partitioner1.getInput().getPartitioner());
            Assert.assertEquals((Object)partitioner, (Object)partitioner2.getInput().getPartitioner());
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCompatiblePartitioningCoGroup() {
        try {
            Partitioner<Long> partitioner = new Partitioner<Long>(){

                public int partition(Long key, int numPartitions) {
                    return 0;
                }
            };
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            input1.partitionCustom((Partitioner)partitioner, 1).coGroup((DataSet)input2.partitionCustom((Partitioner)partitioner, 0)).where(new int[]{1}).equalTo(new int[]{0}).with(new DummyCoGroupFunction()).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            DualInputPlanNode coGroup = (DualInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode partitioner1 = (SingleInputPlanNode)coGroup.getInput1().getSource();
            SingleInputPlanNode partitioner2 = (SingleInputPlanNode)coGroup.getInput2().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)coGroup.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)coGroup.getInput2().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)partitioner1.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)partitioner2.getInput().getShipStrategy());
            Assert.assertEquals((Object)partitioner, (Object)partitioner1.getInput().getPartitioner());
            Assert.assertEquals((Object)partitioner, (Object)partitioner2.getInput().getPartitioner());
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

