/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.costs;

import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.Costs;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.dag.EstimateProvider;
import org.junit.Assert;
import org.junit.Test;

public class DefaultCostEstimatorTest {
    private static final long SMALL_DATA_SIZE = 10000L;
    private static final long SMALL_RECORD_COUNT = 100L;
    private static final long MEDIUM_DATA_SIZE = 500000000L;
    private static final long MEDIUM_RECORD_COUNT = 500000L;
    private static final long BIG_DATA_SIZE = 100000000000L;
    private static final long BIG_RECORD_COUNT = 100000000L;
    private static final EstimateProvider UNKNOWN_ESTIMATES = new UnknownEstimates();
    private static final EstimateProvider ZERO_ESTIMATES = new Estimates(0L, 0L);
    private static final EstimateProvider SMALL_ESTIMATES = new Estimates(10000L, 100L);
    private static final EstimateProvider MEDIUM_ESTIMATES = new Estimates(500000000L, 500000L);
    private static final EstimateProvider BIG_ESTIMATES = new Estimates(100000000000L, 100000000L);
    private final CostEstimator costEstimator = new DefaultCostEstimator();

    @Test
    public void testShipStrategiesIsolated() {
        this.testShipStrategiesIsolated(UNKNOWN_ESTIMATES, 1);
        this.testShipStrategiesIsolated(UNKNOWN_ESTIMATES, 10);
        this.testShipStrategiesIsolated(ZERO_ESTIMATES, 1);
        this.testShipStrategiesIsolated(ZERO_ESTIMATES, 10);
        this.testShipStrategiesIsolated(SMALL_ESTIMATES, 1);
        this.testShipStrategiesIsolated(SMALL_ESTIMATES, 10);
        this.testShipStrategiesIsolated(BIG_ESTIMATES, 1);
        this.testShipStrategiesIsolated(BIG_ESTIMATES, 10);
    }

    private void testShipStrategiesIsolated(EstimateProvider estimates, int targetParallelism) {
        Costs random = new Costs();
        this.costEstimator.addRandomPartitioningCost(estimates, random);
        Costs hash = new Costs();
        this.costEstimator.addHashPartitioningCost(estimates, hash);
        Costs range = new Costs();
        this.costEstimator.addRangePartitionCost(estimates, range);
        Costs broadcast = new Costs();
        this.costEstimator.addBroadcastCost(estimates, targetParallelism, broadcast);
        int randomVsHash = random.compareTo(hash);
        int hashVsRange = hash.compareTo(range);
        int hashVsBroadcast = hash.compareTo(broadcast);
        int rangeVsBroadcast = range.compareTo(broadcast);
        Assert.assertTrue((randomVsHash <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashVsRange < 0 ? 1 : 0) != 0);
        if (targetParallelism > 1) {
            Assert.assertTrue((hashVsBroadcast < 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((hashVsBroadcast <= 0 ? 1 : 0) != 0);
        }
        if (targetParallelism > 1) {
            Assert.assertTrue((rangeVsBroadcast < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testShipStrategyCombinationsPlain() {
        Costs hashBothSmall = new Costs();
        Costs hashSmallAndLarge = new Costs();
        Costs hashBothLarge = new Costs();
        Costs hashSmallBcLarge10 = new Costs();
        Costs hashLargeBcSmall10 = new Costs();
        Costs hashSmallBcLarge1000 = new Costs();
        Costs hashLargeBcSmall1000 = new Costs();
        Costs forwardSmallBcLarge10 = new Costs();
        Costs forwardLargeBcSmall10 = new Costs();
        Costs forwardSmallBcLarge1000 = new Costs();
        Costs forwardLargeBcSmall1000 = new Costs();
        this.costEstimator.addHashPartitioningCost(MEDIUM_ESTIMATES, hashBothSmall);
        this.costEstimator.addHashPartitioningCost(MEDIUM_ESTIMATES, hashBothSmall);
        this.costEstimator.addHashPartitioningCost(MEDIUM_ESTIMATES, hashSmallAndLarge);
        this.costEstimator.addHashPartitioningCost(BIG_ESTIMATES, hashSmallAndLarge);
        this.costEstimator.addHashPartitioningCost(BIG_ESTIMATES, hashBothLarge);
        this.costEstimator.addHashPartitioningCost(BIG_ESTIMATES, hashBothLarge);
        this.costEstimator.addHashPartitioningCost(MEDIUM_ESTIMATES, hashSmallBcLarge10);
        this.costEstimator.addBroadcastCost(BIG_ESTIMATES, 10, hashSmallBcLarge10);
        this.costEstimator.addHashPartitioningCost(BIG_ESTIMATES, hashLargeBcSmall10);
        this.costEstimator.addBroadcastCost(MEDIUM_ESTIMATES, 10, hashLargeBcSmall10);
        this.costEstimator.addHashPartitioningCost(MEDIUM_ESTIMATES, hashSmallBcLarge1000);
        this.costEstimator.addBroadcastCost(BIG_ESTIMATES, 1000, hashSmallBcLarge1000);
        this.costEstimator.addHashPartitioningCost(BIG_ESTIMATES, hashLargeBcSmall1000);
        this.costEstimator.addBroadcastCost(MEDIUM_ESTIMATES, 1000, hashLargeBcSmall1000);
        this.costEstimator.addBroadcastCost(BIG_ESTIMATES, 10, forwardSmallBcLarge10);
        this.costEstimator.addBroadcastCost(MEDIUM_ESTIMATES, 10, forwardLargeBcSmall10);
        this.costEstimator.addBroadcastCost(BIG_ESTIMATES, 1000, forwardSmallBcLarge1000);
        this.costEstimator.addBroadcastCost(MEDIUM_ESTIMATES, 1000, forwardLargeBcSmall1000);
        Assert.assertTrue((hashBothSmall.compareTo(hashSmallAndLarge) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashSmallAndLarge.compareTo(hashBothLarge) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeBcSmall10.compareTo(hashSmallBcLarge10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall10.compareTo(forwardSmallBcLarge10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeBcSmall1000.compareTo(hashSmallBcLarge1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall1000.compareTo(forwardSmallBcLarge1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall10.compareTo(hashSmallAndLarge) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall1000.compareTo(hashSmallAndLarge) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashSmallBcLarge10.compareTo(hashSmallBcLarge1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeBcSmall10.compareTo(hashLargeBcSmall1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardSmallBcLarge10.compareTo(forwardSmallBcLarge1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall10.compareTo(forwardLargeBcSmall1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardSmallBcLarge10.compareTo(hashSmallBcLarge10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardSmallBcLarge1000.compareTo(hashSmallBcLarge1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall10.compareTo(hashLargeBcSmall10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((forwardLargeBcSmall1000.compareTo(hashLargeBcSmall1000) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testShipStrategyCombinationsWithUnknowns() {
        this.testShipStrategyCombinationsWithUnknowns(UNKNOWN_ESTIMATES);
        this.testShipStrategyCombinationsWithUnknowns(ZERO_ESTIMATES);
        this.testShipStrategyCombinationsWithUnknowns(SMALL_ESTIMATES);
        this.testShipStrategyCombinationsWithUnknowns(MEDIUM_ESTIMATES);
        this.testShipStrategyCombinationsWithUnknowns(BIG_ESTIMATES);
    }

    private void testShipStrategyCombinationsWithUnknowns(EstimateProvider knownEstimates) {
        Costs hashBoth = new Costs();
        Costs bcKnown10 = new Costs();
        Costs bcUnknown10 = new Costs();
        Costs bcKnown1000 = new Costs();
        Costs bcUnknown1000 = new Costs();
        this.costEstimator.addHashPartitioningCost(knownEstimates, hashBoth);
        this.costEstimator.addHashPartitioningCost(UNKNOWN_ESTIMATES, hashBoth);
        this.costEstimator.addBroadcastCost(knownEstimates, 10, bcKnown10);
        this.costEstimator.addBroadcastCost(UNKNOWN_ESTIMATES, 10, bcUnknown10);
        this.costEstimator.addBroadcastCost(knownEstimates, 1000, bcKnown1000);
        this.costEstimator.addBroadcastCost(UNKNOWN_ESTIMATES, 1000, bcUnknown1000);
        Assert.assertTrue((hashBoth.compareTo(bcKnown10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashBoth.compareTo(bcUnknown10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashBoth.compareTo(bcKnown1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashBoth.compareTo(bcUnknown1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((bcKnown10.compareTo(bcUnknown10) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((bcKnown1000.compareTo(bcUnknown1000) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((bcKnown10.compareTo(bcKnown1000) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((bcUnknown10.compareTo(bcUnknown1000) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJoinCostFormulasPlain() {
        Costs hashBothSmall = new Costs();
        Costs hashBothLarge = new Costs();
        Costs hashSmallBuild = new Costs();
        Costs hashLargeBuild = new Costs();
        this.costEstimator.addHybridHashCosts(SMALL_ESTIMATES, BIG_ESTIMATES, hashSmallBuild, 1);
        this.costEstimator.addHybridHashCosts(BIG_ESTIMATES, SMALL_ESTIMATES, hashLargeBuild, 1);
        this.costEstimator.addHybridHashCosts(SMALL_ESTIMATES, SMALL_ESTIMATES, hashBothSmall, 1);
        this.costEstimator.addHybridHashCosts(BIG_ESTIMATES, BIG_ESTIMATES, hashBothLarge, 1);
        Assert.assertTrue((hashBothSmall.compareTo(hashSmallBuild) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashSmallBuild.compareTo(hashLargeBuild) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeBuild.compareTo(hashBothLarge) < 0 ? 1 : 0) != 0);
        Costs mergeBothSmall = new Costs();
        Costs mergeBothLarge = new Costs();
        Costs mergeSmallFirst = new Costs();
        Costs mergeSmallSecond = new Costs();
        this.costEstimator.addLocalSortCost(SMALL_ESTIMATES, mergeSmallFirst);
        this.costEstimator.addLocalSortCost(BIG_ESTIMATES, mergeSmallFirst);
        this.costEstimator.addLocalMergeCost(SMALL_ESTIMATES, BIG_ESTIMATES, mergeSmallFirst, 1);
        this.costEstimator.addLocalSortCost(BIG_ESTIMATES, mergeSmallSecond);
        this.costEstimator.addLocalSortCost(SMALL_ESTIMATES, mergeSmallSecond);
        this.costEstimator.addLocalMergeCost(BIG_ESTIMATES, SMALL_ESTIMATES, mergeSmallSecond, 1);
        this.costEstimator.addLocalSortCost(SMALL_ESTIMATES, mergeBothSmall);
        this.costEstimator.addLocalSortCost(SMALL_ESTIMATES, mergeBothSmall);
        this.costEstimator.addLocalMergeCost(SMALL_ESTIMATES, SMALL_ESTIMATES, mergeBothSmall, 1);
        this.costEstimator.addLocalSortCost(BIG_ESTIMATES, mergeBothLarge);
        this.costEstimator.addLocalSortCost(BIG_ESTIMATES, mergeBothLarge);
        this.costEstimator.addLocalMergeCost(BIG_ESTIMATES, BIG_ESTIMATES, mergeBothLarge, 1);
        Assert.assertTrue((mergeBothSmall.compareTo(mergeSmallFirst) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((mergeBothSmall.compareTo(mergeSmallSecond) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((mergeSmallFirst.compareTo(mergeSmallSecond) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mergeSmallFirst.compareTo(mergeBothLarge) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((mergeSmallSecond.compareTo(mergeBothLarge) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashBothSmall.compareTo(mergeBothSmall) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashBothLarge.compareTo(mergeBothLarge) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashSmallBuild.compareTo(mergeSmallFirst) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashSmallBuild.compareTo(mergeSmallSecond) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeBuild.compareTo(mergeSmallFirst) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeBuild.compareTo(mergeSmallSecond) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJoinCostFormulasWithWeights() {
        this.testJoinCostFormulasWithWeights(UNKNOWN_ESTIMATES, SMALL_ESTIMATES);
        this.testJoinCostFormulasWithWeights(SMALL_ESTIMATES, UNKNOWN_ESTIMATES);
        this.testJoinCostFormulasWithWeights(UNKNOWN_ESTIMATES, MEDIUM_ESTIMATES);
        this.testJoinCostFormulasWithWeights(MEDIUM_ESTIMATES, UNKNOWN_ESTIMATES);
        this.testJoinCostFormulasWithWeights(BIG_ESTIMATES, MEDIUM_ESTIMATES);
        this.testJoinCostFormulasWithWeights(MEDIUM_ESTIMATES, BIG_ESTIMATES);
    }

    private void testJoinCostFormulasWithWeights(EstimateProvider e1, EstimateProvider e2) {
        Costs hf1 = new Costs();
        Costs hf5 = new Costs();
        Costs hs1 = new Costs();
        Costs hs5 = new Costs();
        Costs mm1 = new Costs();
        Costs mm5 = new Costs();
        this.costEstimator.addHybridHashCosts(e1, e2, hf1, 1);
        this.costEstimator.addHybridHashCosts(e1, e2, hf5, 5);
        this.costEstimator.addHybridHashCosts(e2, e1, hs1, 1);
        this.costEstimator.addHybridHashCosts(e2, e1, hs5, 5);
        this.costEstimator.addLocalSortCost(e1, mm1);
        this.costEstimator.addLocalSortCost(e2, mm1);
        this.costEstimator.addLocalMergeCost(e1, e2, mm1, 1);
        this.costEstimator.addLocalSortCost(e1, mm5);
        this.costEstimator.addLocalSortCost(e2, mm5);
        mm5.multiplyWith(5);
        this.costEstimator.addLocalMergeCost(e1, e2, mm5, 5);
        Assert.assertTrue((hf1.compareTo(hf5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hs1.compareTo(hs5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((mm1.compareTo(mm5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hf1.compareTo(mm1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hs1.compareTo(mm1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hf5.compareTo(mm5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hs5.compareTo(mm5) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHashJoinCostFormulasWithCaches() {
        Costs hashBothUnknown10 = new Costs();
        Costs hashBothUnknownCached10 = new Costs();
        Costs hashBothSmall10 = new Costs();
        Costs hashBothSmallCached10 = new Costs();
        Costs hashSmallLarge10 = new Costs();
        Costs hashSmallLargeCached10 = new Costs();
        Costs hashLargeSmall10 = new Costs();
        Costs hashLargeSmallCached10 = new Costs();
        Costs hashLargeSmall1 = new Costs();
        Costs hashLargeSmallCached1 = new Costs();
        this.costEstimator.addHybridHashCosts(UNKNOWN_ESTIMATES, UNKNOWN_ESTIMATES, hashBothUnknown10, 10);
        this.costEstimator.addCachedHybridHashCosts(UNKNOWN_ESTIMATES, UNKNOWN_ESTIMATES, hashBothUnknownCached10, 10);
        this.costEstimator.addHybridHashCosts(MEDIUM_ESTIMATES, MEDIUM_ESTIMATES, hashBothSmall10, 10);
        this.costEstimator.addCachedHybridHashCosts(MEDIUM_ESTIMATES, MEDIUM_ESTIMATES, hashBothSmallCached10, 10);
        this.costEstimator.addHybridHashCosts(MEDIUM_ESTIMATES, BIG_ESTIMATES, hashSmallLarge10, 10);
        this.costEstimator.addCachedHybridHashCosts(MEDIUM_ESTIMATES, BIG_ESTIMATES, hashSmallLargeCached10, 10);
        this.costEstimator.addHybridHashCosts(BIG_ESTIMATES, MEDIUM_ESTIMATES, hashLargeSmall10, 10);
        this.costEstimator.addCachedHybridHashCosts(BIG_ESTIMATES, MEDIUM_ESTIMATES, hashLargeSmallCached10, 10);
        this.costEstimator.addHybridHashCosts(BIG_ESTIMATES, MEDIUM_ESTIMATES, hashLargeSmall1, 1);
        this.costEstimator.addCachedHybridHashCosts(BIG_ESTIMATES, MEDIUM_ESTIMATES, hashLargeSmallCached1, 1);
        Assert.assertTrue((hashBothUnknown10.compareTo(hashBothUnknownCached10) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashBothSmall10.compareTo(hashBothSmallCached10) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashSmallLarge10.compareTo(hashSmallLargeCached10) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeSmall10.compareTo(hashLargeSmallCached10) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeSmallCached10.compareTo(hashSmallLargeCached10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((hashLargeSmall1.compareTo(hashLargeSmallCached1) == 0 ? 1 : 0) != 0);
    }

    private static final class Estimates
    implements EstimateProvider {
        private final long size;
        private final long records;
        private final float width;

        public Estimates(long size, long records) {
            this(size, records, -1.0f);
        }

        public Estimates(long size, long records, float width) {
            this.size = size;
            this.records = records;
            this.width = width;
        }

        public long getEstimatedOutputSize() {
            return this.size;
        }

        public long getEstimatedNumRecords() {
            return this.records;
        }

        public float getEstimatedAvgWidthPerOutputRecord() {
            return this.width;
        }
    }

    private static final class UnknownEstimates
    implements EstimateProvider {
        private UnknownEstimates() {
        }

        public long getEstimatedOutputSize() {
            return -1L;
        }

        public long getEstimatedNumRecords() {
            return -1L;
        }

        public float getEstimatedAvgWidthPerOutputRecord() {
            return -1.0f;
        }
    }
}

