/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.WorksetIterationPlanNode;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class WorksetIterationCornerCasesTest
extends CompilerTestBase {
    @Test
    public void testWorksetIterationNotDependingOnSolutionSet() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            MapOperator input = env.generateSequence(1L, 100L).map(new Duplicator());
            DeltaIteration iteration = input.iterateDelta((DataSet)input, 100, new int[]{1});
            MapOperator iterEnd = iteration.getWorkset().map(new TestMapper());
            iteration.closeWith((DataSet)iterEnd, (DataSet)iterEnd).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            WorksetIterationPlanNode wipn = (WorksetIterationPlanNode)((SinkPlanNode)op.getDataSinks().iterator().next()).getInput().getSource();
            Assert.assertTrue((boolean)wipn.getSolutionSetPlanNode().getOutgoingChannels().isEmpty());
            JobGraphGenerator jgg = new JobGraphGenerator();
            jgg.compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static final class TestMapper<T>
    implements MapFunction<T, T> {
        private TestMapper() {
        }

        public T map(T value) {
            return value;
        }
    }

    private static final class Duplicator<T>
    implements MapFunction<T, Tuple2<T, T>> {
        private Duplicator() {
        }

        public Tuple2<T, T> map(T value) {
            return new Tuple2(value, value);
        }
    }
}

