/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class PartitionPushdownTest
extends CompilerTestBase {
    @Test
    public void testPartitioningNotPushedDown() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            input.groupBy(new int[]{0, 1}).sum(2).groupBy(new int[]{0}).sum(1).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode agg2Reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode agg2Combiner = (SingleInputPlanNode)agg2Reducer.getInput().getSource();
            SingleInputPlanNode agg1Reducer = (SingleInputPlanNode)agg2Combiner.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)agg2Reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)new FieldList(0), (Object)agg2Reducer.getInput().getShipStrategyKeys());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)agg2Combiner.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)agg1Reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)new FieldList(new int[]{0, 1}), (Object)agg1Reducer.getInput().getShipStrategyKeys());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPartitioningReused() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            input.groupBy(new int[]{0}).sum(1).groupBy(new int[]{0, 1}).sum(2).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode agg2Reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode agg1Reducer = (SingleInputPlanNode)agg2Reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)agg2Reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)agg1Reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)new FieldList(0), (Object)agg1Reducer.getInput().getShipStrategyKeys());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

