/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.optimizer.dag.DataSourceNode;
import org.apache.flink.optimizer.dag.JoinNode;
import org.apache.flink.optimizer.dag.MapNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.optimizer.testfunctions.DummyFlatJoinFunction;
import org.apache.flink.optimizer.testfunctions.IdentityMapper;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.junit.Assert;
import org.junit.Test;

public class FeedbackPropertiesMatchTest {
    @Test
    public void testNoPartialSolutionFoundSingleInputOnly() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source");
            SourcePlanNode otherTarget = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source");
            Channel toMap1 = new Channel((PlanNode)target);
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)map1);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            GlobalProperties gp = new GlobalProperties();
            LocalProperties lp = new LocalProperties();
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = map2.checkPartialSolutionPropertiesMet((PlanNode)otherTarget, gp, lp);
            Assert.assertTrue((report == PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSingleInputOperators() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source");
            Channel toMap1 = new Channel((PlanNode)target);
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)map1);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            GlobalProperties gp = new GlobalProperties();
            LocalProperties lp = new LocalProperties();
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 5}));
            lp = new LocalProperties();
            report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 5}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 5}));
            lp = new LocalProperties();
            RequestedGlobalProperties reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned((FieldSet)new FieldList(new int[]{2, 5}));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            RequestedLocalProperties reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 5}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned((FieldSet)new FieldList(new int[]{2, 5}));
            RequestedLocalProperties reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2}));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(2));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned(new FieldSet(new int[]{2, 5}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(1));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 1}));
            lp = new LocalProperties();
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned((FieldSet)new FieldList(new int[]{2, 5}));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
            gp = new GlobalProperties();
            lp = LocalProperties.forGrouping((FieldList)new FieldList(1));
            reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 1}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(1));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{2, 5}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(1));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(1));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(1));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(1));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(2));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 5}));
            lp = new LocalProperties();
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned((FieldSet)new FieldList(new int[]{2, 5}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(null);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 5}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned((FieldSet)new FieldList(new int[]{2, 5}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(2));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{1, 2}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned(new FieldSet(new int[]{2, 5}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(1));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 1}));
            lp = new LocalProperties();
            reqGp = new RequestedGlobalProperties();
            reqGp.setHashPartitioned(new FieldSet(new int[]{2, 5}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(null);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
            gp = new GlobalProperties();
            lp = LocalProperties.forGrouping((FieldList)new FieldList(1));
            reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp);
            report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{2, 1}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(1));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning(new FieldSet(new int[]{2, 5}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(1));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(1));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(1));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(1));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(2));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.EMPTY;
            RequestedGlobalProperties reqGp1 = new RequestedGlobalProperties();
            reqGp1.setAnyPartitioning((FieldSet)new FieldList(new int[]{1, 2}));
            RequestedGlobalProperties reqGp2 = new RequestedGlobalProperties();
            reqGp2.setHashPartitioned((FieldSet)new FieldList(new int[]{1, 2}));
            toMap1.setRequiredGlobalProps(reqGp1);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp2);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            lp = LocalProperties.forOrdering((Ordering)new Ordering(3, null, Order.ASCENDING).appendOrdering(Integer.valueOf(1), null, Order.DESCENDING));
            RequestedLocalProperties reqLp1 = new RequestedLocalProperties();
            reqLp1.setGroupedFields((FieldSet)new FieldList(new int[]{3, 1}));
            RequestedLocalProperties reqLp22 = new RequestedLocalProperties();
            reqLp22.setOrdering(new Ordering(3, null, Order.ANY).appendOrdering(Integer.valueOf(1), null, Order.ANY));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp1);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp22);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{1, 2}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(2));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{1, 2}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(2));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report3 != null && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report3 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{1, 2}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{2, 3}));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{2, 3}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{2, 3}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp2);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning((FieldSet)new FieldList(new int[]{1, 2}));
            reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1, 3}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(null);
            report3 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSingleInputOperatorsWithReCreation() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source");
            Channel toMap1 = new Channel((PlanNode)target);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)map1);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            GlobalProperties gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            LocalProperties lp = LocalProperties.EMPTY;
            RequestedGlobalProperties reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning(new FieldSet(new int[]{2, 5}));
            toMap1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(new int[]{2, 5}), DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(reqGp);
            toMap2.setRequiredLocalProps(null);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.MET, (Object)report);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.EMPTY;
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning(new FieldSet(new int[]{2, 5}));
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            toMap2.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(new int[]{2, 5}), DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forOrdering((Ordering)new Ordering(3, null, Order.ASCENDING).appendOrdering(Integer.valueOf(1), null, Order.DESCENDING));
            RequestedLocalProperties reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{4, 1}));
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{5, 7}), new boolean[]{false, false});
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(reqLp);
            report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forOrdering((Ordering)new Ordering(3, null, Order.ASCENDING).appendOrdering(Integer.valueOf(1), null, Order.DESCENDING));
            reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{4, 1}));
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{5, 7}), new boolean[]{false, false});
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(reqLp);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            report = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{1, 2}));
            lp = LocalProperties.forOrdering((Ordering)new Ordering(3, null, Order.ASCENDING).appendOrdering(Integer.valueOf(1), null, Order.DESCENDING));
            reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning(new FieldSet(new int[]{5, 7}));
            RequestedLocalProperties reqLp2 = new RequestedLocalProperties();
            reqLp2.setGroupedFields((FieldSet)new FieldList(new int[]{5, 7}));
            toMap1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(new int[]{5, 7}), DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{5, 7}), new boolean[]{false, false});
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            toMap1.setRequiredGlobalProps(reqGp);
            toMap1.setRequiredLocalProps(reqLp2);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report2 = map2.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.MET, (Object)report2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSingleInputOperatorsChainOfThree() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source");
            Channel toMap1 = new Channel((PlanNode)target);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)map1);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            Channel toMap3 = new Channel((PlanNode)map2);
            SingleInputPlanNode map3 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 3", toMap3, DriverStrategy.MAP);
            GlobalProperties gp = new GlobalProperties();
            LocalProperties lp = LocalProperties.forOrdering((Ordering)new Ordering(3, null, Order.ASCENDING).appendOrdering(Integer.valueOf(1), null, Order.DESCENDING));
            RequestedLocalProperties reqLp = new RequestedLocalProperties();
            reqLp.setGroupedFields((FieldSet)new FieldList(new int[]{4, 1}));
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{5, 7}), new boolean[]{false, false});
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            toMap3.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap3.setLocalStrategy(LocalStrategy.NONE);
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            toMap3.setRequiredGlobalProps(null);
            toMap3.setRequiredLocalProps(reqLp);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = map3.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(new int[]{5, 3}));
            lp = LocalProperties.EMPTY;
            RequestedGlobalProperties reqGp = new RequestedGlobalProperties();
            reqGp.setAnyPartitioning(new FieldSet(new int[]{2, 3}));
            toMap1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(new int[]{1, 2}), DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            toMap3.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap3.setLocalStrategy(LocalStrategy.NONE);
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toMap2.setRequiredGlobalProps(null);
            toMap2.setRequiredLocalProps(null);
            toMap3.setRequiredGlobalProps(reqGp);
            toMap3.setRequiredLocalProps(null);
            report = map3.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNoPartialSolutionFoundTwoInputOperator() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Partial Solution");
            SourcePlanNode source1 = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source 1");
            SourcePlanNode source2 = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Source 2");
            Channel toMap1 = new Channel((PlanNode)source1);
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)source2);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            Channel toJoin1 = new Channel((PlanNode)map1);
            Channel toJoin2 = new Channel((PlanNode)map2);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            toJoin2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin2.setLocalStrategy(LocalStrategy.NONE);
            DualInputPlanNode join = new DualInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getJoinNode(), "Join", toJoin1, toJoin2, DriverStrategy.HYBRIDHASH_BUILD_FIRST);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = join.checkPartialSolutionPropertiesMet((PlanNode)target, new GlobalProperties(), new LocalProperties());
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION, (Object)report);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTwoOperatorsOneIndependent() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Partial Solution");
            SourcePlanNode source = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Other Source");
            Channel toMap1 = new Channel((PlanNode)target);
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)source);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            Channel toJoin1 = new Channel((PlanNode)map1);
            Channel toJoin2 = new Channel((PlanNode)map2);
            DualInputPlanNode join = new DualInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getJoinNode(), "Join", toJoin1, toJoin2, DriverStrategy.HYBRIDHASH_BUILD_FIRST);
            Channel toAfterJoin = new Channel((PlanNode)join);
            toAfterJoin.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toAfterJoin.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode afterJoin = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "After Join Mapper", toAfterJoin, DriverStrategy.MAP);
            toMap2.setShipStrategy(ShipStrategyType.BROADCAST, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{2, 7}), new boolean[]{true, true});
            RequestedGlobalProperties joinGp = new RequestedGlobalProperties();
            joinGp.setFullyReplicated();
            RequestedLocalProperties joinLp = new RequestedLocalProperties();
            joinLp.setOrdering(new Ordering(2, null, Order.ASCENDING).appendOrdering(Integer.valueOf(7), null, Order.ASCENDING));
            toJoin2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin2.setLocalStrategy(LocalStrategy.NONE);
            toJoin2.setRequiredGlobalProps(joinGp);
            toJoin2.setRequiredLocalProps(joinLp);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            GlobalProperties gp = new GlobalProperties();
            LocalProperties lp = LocalProperties.EMPTY;
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = join.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            report = join.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            RequestedGlobalProperties rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            RequestedLocalProperties rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(2));
            toJoin1.setRequiredGlobalProps(rgp);
            toJoin1.setRequiredLocalProps(rlp);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report2 = join.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2, 3}));
            toJoin1.setRequiredGlobalProps(rgp);
            toJoin1.setRequiredLocalProps(rlp);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            report2 = join.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toMap1.setRequiredGlobalProps(rgp);
            toMap1.setRequiredLocalProps(rlp);
            toJoin1.setRequiredGlobalProps(null);
            toJoin1.setRequiredLocalProps(null);
            toJoin1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(new int[]{2, 1}), DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{7, 3}), new boolean[]{true, false});
            report2 = join.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toMap1.setRequiredGlobalProps(null);
            toMap1.setRequiredLocalProps(null);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            toJoin1.setRequiredGlobalProps(rgp);
            toJoin1.setRequiredLocalProps(rlp);
            toAfterJoin.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toAfterJoin.setLocalStrategy(LocalStrategy.NONE);
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(rlp);
            report2 = join.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            RequestedGlobalProperties rgp1 = new RequestedGlobalProperties();
            rgp1.setHashPartitioned((FieldSet)new FieldList(0));
            RequestedGlobalProperties rgp2 = new RequestedGlobalProperties();
            rgp2.setHashPartitioned((FieldSet)new FieldList(3));
            RequestedLocalProperties rlp1 = new RequestedLocalProperties();
            rlp1.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            RequestedLocalProperties rlp2 = new RequestedLocalProperties();
            rlp2.setGroupedFields((FieldSet)new FieldList(new int[]{3, 4}));
            toJoin1.setRequiredGlobalProps(rgp1);
            toJoin1.setRequiredLocalProps(rlp1);
            toAfterJoin.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toAfterJoin.setLocalStrategy(LocalStrategy.NONE);
            toAfterJoin.setRequiredGlobalProps(rgp2);
            toAfterJoin.setRequiredLocalProps(rlp2);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report3 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setAnyPartitioning(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(1));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2, 3}));
            toJoin1.setRequiredGlobalProps(null);
            toJoin1.setRequiredLocalProps(null);
            toJoin1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(new int[]{2, 1}), DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{7, 3}), new boolean[]{true, false});
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(rlp);
            report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setAnyPartitioning(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            RequestedLocalProperties rlp3 = new RequestedLocalProperties();
            rlp3.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2, 3}));
            toJoin1.setRequiredGlobalProps(null);
            toJoin1.setRequiredLocalProps(null);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{7, 3}), new boolean[]{true, false});
            toAfterJoin.setRequiredGlobalProps(null);
            toAfterJoin.setRequiredLocalProps(rlp3);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report4 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report4 != null && report4 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report4 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setAnyPartitioning(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(1));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{1, 2, 3}));
            toJoin1.setRequiredGlobalProps(null);
            toJoin1.setRequiredLocalProps(null);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.SORT, new FieldList(new int[]{7, 3}), new boolean[]{true, false});
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(rlp);
            report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTwoOperatorsBothDependent() {
        try {
            SourcePlanNode target = new SourcePlanNode(FeedbackPropertiesMatchTest.getSourceNode(), "Partial Solution");
            Channel toMap1 = new Channel((PlanNode)target);
            toMap1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap1.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map1 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 1", toMap1, DriverStrategy.MAP);
            Channel toMap2 = new Channel((PlanNode)target);
            toMap2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toMap2.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode map2 = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "Mapper 2", toMap2, DriverStrategy.MAP);
            Channel toJoin1 = new Channel((PlanNode)map1);
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            Channel toJoin2 = new Channel((PlanNode)map2);
            toJoin2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin2.setLocalStrategy(LocalStrategy.NONE);
            DualInputPlanNode join = new DualInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getJoinNode(), "Join", toJoin1, toJoin2, DriverStrategy.HYBRIDHASH_BUILD_FIRST);
            Channel toAfterJoin = new Channel((PlanNode)join);
            toAfterJoin.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toAfterJoin.setLocalStrategy(LocalStrategy.NONE);
            SingleInputPlanNode afterJoin = new SingleInputPlanNode((OptimizerNode)FeedbackPropertiesMatchTest.getMapNode(), "After Join Mapper", toAfterJoin, DriverStrategy.MAP);
            GlobalProperties gp = new GlobalProperties();
            LocalProperties lp = LocalProperties.EMPTY;
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            report = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report != null && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            RequestedGlobalProperties rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            RequestedLocalProperties rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toJoin1.setRequiredGlobalProps(rgp);
            toJoin1.setRequiredLocalProps(rlp);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toJoin1.setRequiredGlobalProps(rgp);
            toJoin1.setRequiredLocalProps(rlp);
            toJoin2.setRequiredGlobalProps(rgp);
            toJoin2.setRequiredLocalProps(rlp);
            report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertTrue((report2 != null && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION && report2 != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET ? 1 : 0) != 0);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            RequestedGlobalProperties rgp1 = new RequestedGlobalProperties();
            rgp1.setHashPartitioned((FieldSet)new FieldList(0));
            RequestedLocalProperties rlp1 = new RequestedLocalProperties();
            rlp1.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            RequestedGlobalProperties rgp2 = new RequestedGlobalProperties();
            rgp2.setHashPartitioned((FieldSet)new FieldList(1));
            RequestedLocalProperties rlp2 = new RequestedLocalProperties();
            rlp2.setGroupedFields((FieldSet)new FieldList(new int[]{0, 3}));
            toJoin1.setRequiredGlobalProps(rgp1);
            toJoin1.setRequiredLocalProps(rlp1);
            toJoin2.setRequiredGlobalProps(rgp2);
            toJoin2.setRequiredLocalProps(rlp2);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report3 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report3);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(1));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{0, 3}));
            toJoin1.setRequiredGlobalProps(null);
            toJoin1.setRequiredLocalProps(null);
            toJoin2.setRequiredGlobalProps(null);
            toJoin2.setRequiredLocalProps(null);
            toJoin1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(88), DataExchangeMode.PIPELINED);
            toJoin2.setShipStrategy(ShipStrategyType.BROADCAST, DataExchangeMode.PIPELINED);
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(rlp);
            report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(0));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{2, 1}));
            toJoin1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(88), DataExchangeMode.PIPELINED);
            toJoin2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(rlp);
            report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.PENDING, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(3));
            rlp = new RequestedLocalProperties();
            rlp.setGroupedFields((FieldSet)new FieldList(new int[]{77, 69}));
            toJoin1.setShipStrategy(ShipStrategyType.PARTITION_HASH, new FieldList(88), DataExchangeMode.PIPELINED);
            toJoin2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(rlp);
            report2 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report2);
            gp = new GlobalProperties();
            gp.setHashPartitioned(new FieldList(0));
            lp = LocalProperties.forGrouping((FieldList)new FieldList(new int[]{2, 1}));
            rgp = new RequestedGlobalProperties();
            rgp.setHashPartitioned((FieldSet)new FieldList(3));
            toJoin1.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.SORT, new FieldList(3), new boolean[]{false});
            toJoin2.setShipStrategy(ShipStrategyType.FORWARD, DataExchangeMode.PIPELINED);
            toJoin1.setLocalStrategy(LocalStrategy.NONE);
            toAfterJoin.setRequiredGlobalProps(rgp);
            toAfterJoin.setRequiredLocalProps(null);
            PlanNode.FeedbackPropertiesMeetRequirementsReport report4 = afterJoin.checkPartialSolutionPropertiesMet((PlanNode)target, gp, lp);
            Assert.assertEquals((Object)PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET, (Object)report4);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static DataSourceNode getSourceNode() {
        return new DataSourceNode(new GenericDataSourceBase((InputFormat)new TextInputFormat(new Path("/")), new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO)));
    }

    private static MapNode getMapNode() {
        return new MapNode((SingleInputOperator)new MapOperatorBase(new IdentityMapper(), new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "map op"));
    }

    private static JoinNode getJoinNode() {
        return new JoinNode(new InnerJoinOperatorBase(new DummyFlatJoinFunction(), new BinaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), new int[]{1}, new int[]{2}, "join op"));
    }
}

