/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.optimizer.dag.TempMode;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.IdentityMapper;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.junit.Assert;
import org.junit.Test;

public class BroadcastVariablePipelinebreakerTest
extends CompilerTestBase {
    @Test
    public void testNoBreakerForIndependentVariable() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource source1 = env.fromElements((Object[])new String[]{"test"});
            DataSource source2 = env.fromElements((Object[])new String[]{"test"});
            ((MapOperator)source1.map(new IdentityMapper()).withBroadcastSet((DataSet)source2, "some name")).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode mapper = (SingleInputPlanNode)sink.getInput().getSource();
            Assert.assertEquals((Object)TempMode.NONE, (Object)mapper.getInput().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getTempMode());
            Assert.assertEquals((Object)DataExchangeMode.PIPELINED, (Object)mapper.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)DataExchangeMode.PIPELINED, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getDataExchangeMode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBreakerForDependentVariable() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource source1 = env.fromElements((Object[])new String[]{"test"});
            ((MapOperator)source1.map(new IdentityMapper()).map(new IdentityMapper()).withBroadcastSet((DataSet)source1, "some name")).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode mapper = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode beforeMapper = (SingleInputPlanNode)mapper.getInput().getSource();
            Assert.assertEquals((Object)TempMode.NONE, (Object)mapper.getInput().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)beforeMapper.getInput().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getTempMode());
            Assert.assertEquals((Object)DataExchangeMode.PIPELINED, (Object)mapper.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)DataExchangeMode.BATCH, (Object)beforeMapper.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)DataExchangeMode.BATCH, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getDataExchangeMode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

