/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.util.Visitor;

public class OperatorResolver
implements Visitor<Operator<?>> {
    private final Map<String, List<Operator<?>>> map = new HashMap();
    private Set<Operator<?>> seen = new HashSet();

    public OperatorResolver(Plan p) {
        p.accept((Visitor)this);
        this.seen = null;
    }

    public <T extends Operator<?>> T getNode(String name) {
        List<Operator<?>> nodes = this.map.get(name);
        if (nodes == null || nodes.isEmpty()) {
            throw new RuntimeException("No nodes found with the given name.");
        }
        if (nodes.size() != 1) {
            throw new RuntimeException("Multiple nodes found with the given name.");
        }
        return (T)nodes.get(0);
    }

    public <T extends Operator<?>> T getNode(String name, Class<? extends RichFunction> stubClass) {
        List<Operator<?>> nodes = this.map.get(name);
        if (nodes == null || nodes.isEmpty()) {
            throw new RuntimeException("No node found with the given name and stub class.");
        }
        Operator<?> found = null;
        for (Operator<?> node : nodes) {
            if (node.getClass() != stubClass) continue;
            if (found == null) {
                found = node;
                continue;
            }
            throw new RuntimeException("Multiple nodes found with the given name and stub class.");
        }
        if (found == null) {
            throw new RuntimeException("No node found with the given name and stub class.");
        }
        return (T)found;
    }

    public List<Operator<?>> getNodes(String name) {
        List<Operator<?>> nodes = this.map.get(name);
        if (nodes == null || nodes.isEmpty()) {
            throw new RuntimeException("No node found with the given name.");
        }
        return new ArrayList(nodes);
    }

    public boolean preVisit(Operator<?> visitable) {
        if (this.seen.add(visitable)) {
            String name = visitable.getName();
            List<Operator<?>> list = this.map.get(name);
            if (list == null) {
                list = new ArrayList(2);
                this.map.put(name, list);
            }
            list.add(visitable);
            if (visitable instanceof BulkIterationBase) {
                ((BulkIterationBase)visitable).getNextPartialSolution().accept((Visitor)this);
            } else if (visitable instanceof DeltaIterationBase) {
                ((DeltaIterationBase)visitable).getSolutionSetDelta().accept((Visitor)this);
                ((DeltaIterationBase)visitable).getNextWorkset().accept((Visitor)this);
            }
            return true;
        }
        return false;
    }

    public void postVisit(Operator<?> visitable) {
    }
}

