/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.java;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.testfunctions.IdentityMapper;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class OpenIterationTest
extends CompilerTestBase {
    @Test
    public void testSinkInOpenBulkIteration() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.generateSequence(1L, 10L);
            IterativeDataSet iteration = input.iterate(10);
            MapOperator mapped = iteration.map(new IdentityMapper());
            mapped.output((OutputFormat)new DiscardingOutputFormat());
            try {
                env.createProgramPlan();
                Assert.fail((String)"should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSinkInClosedBulkIteration() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.generateSequence(1L, 10L);
            IterativeDataSet iteration = input.iterate(10);
            MapOperator mapped = iteration.map(new IdentityMapper());
            iteration.closeWith((DataSet)mapped).output((OutputFormat)new DiscardingOutputFormat());
            mapped.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            try {
                this.compileNoStats((Plan)p);
                Assert.fail((String)"should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSinkOnSolutionSetDeltaIteration() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DeltaIteration iteration = input.iterateDelta((DataSet)input, 10, new int[]{0});
            MapOperator mapped = iteration.getSolutionSet().map(new IdentityMapper());
            mapped.output((OutputFormat)new DiscardingOutputFormat());
            try {
                env.createProgramPlan();
                Assert.fail((String)"should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSinkOnWorksetDeltaIteration() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DeltaIteration iteration = input.iterateDelta((DataSet)input, 10, new int[]{0});
            MapOperator mapped = iteration.getWorkset().map(new IdentityMapper());
            mapped.output((OutputFormat)new DiscardingOutputFormat());
            try {
                env.createProgramPlan();
                Assert.fail((String)"should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOperationOnSolutionSet() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DeltaIteration iteration = input.iterateDelta((DataSet)input, 10, new int[]{0});
            MapOperator mapped = iteration.getSolutionSet().map(new IdentityMapper());
            JoinOperator.ProjectJoin joined = iteration.getWorkset().join((DataSet)mapped).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{1}).projectSecond(new int[]{0});
            iteration.closeWith((DataSet)joined, (DataSet)joined).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            try {
                this.compileNoStats((Plan)p);
                Assert.fail((String)"should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

