/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.java;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.util.Visitor;
import org.junit.Assert;
import org.junit.Test;

public class JoinTranslationTest
extends CompilerTestBase {
    @Test
    public void testBroadcastHashFirstTest() {
        try {
            DualInputPlanNode node = this.createPlanAndGetJoinNode(JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
            Assert.assertEquals((Object)ShipStrategyType.BROADCAST, (Object)node.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)node.getInput2().getShipStrategy());
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_FIRST, (Object)node.getDriverStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @Test
    public void testBroadcastHashSecondTest() {
        try {
            DualInputPlanNode node = this.createPlanAndGetJoinNode(JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)node.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.BROADCAST, (Object)node.getInput2().getShipStrategy());
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND, (Object)node.getDriverStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @Test
    public void testPartitionHashFirstTest() {
        try {
            DualInputPlanNode node = this.createPlanAndGetJoinNode(JoinOperatorBase.JoinHint.REPARTITION_HASH_FIRST);
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput2().getShipStrategy());
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_FIRST, (Object)node.getDriverStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @Test
    public void testPartitionHashSecondTest() {
        try {
            DualInputPlanNode node = this.createPlanAndGetJoinNode(JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND);
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput2().getShipStrategy());
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND, (Object)node.getDriverStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @Test
    public void testPartitionSortMergeTest() {
        try {
            DualInputPlanNode node = this.createPlanAndGetJoinNode(JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE);
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput2().getShipStrategy());
            Assert.assertEquals((Object)DriverStrategy.INNER_MERGE, (Object)node.getDriverStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @Test
    public void testOptimizerChoosesTest() {
        try {
            DualInputPlanNode node = this.createPlanAndGetJoinNode(JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)node.getInput2().getShipStrategy());
            Assert.assertTrue((DriverStrategy.HYBRIDHASH_BUILD_FIRST == node.getDriverStrategy() || DriverStrategy.HYBRIDHASH_BUILD_SECOND == node.getDriverStrategy() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    private DualInputPlanNode createPlanAndGetJoinNode(JoinOperatorBase.JoinHint hint) {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource i1 = env.generateSequence(1L, 1000L);
        DataSource i2 = env.generateSequence(1L, 1000L);
        i1.join((DataSet)i2, hint).where(new IdentityKeySelector()).equalTo(new IdentityKeySelector()).output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        plan.accept(new Visitor<Operator<?>>(){

            public boolean preVisit(Operator<?> visitable) {
                if (visitable instanceof GenericDataSourceBase) {
                    GenericDataSourceBase source = (GenericDataSourceBase)visitable;
                    JoinTranslationTest.this.setSourceStatistics(source, 10000000L, 1000.0f);
                }
                return true;
            }

            public void postVisit(Operator<?> visitable) {
            }
        });
        OptimizedPlan op = this.compileWithStats((Plan)plan);
        return (DualInputPlanNode)((SinkPlanNode)op.getDataSinks().iterator().next()).getInput().getSource();
    }

    private static final class IdentityKeySelector<T>
    implements KeySelector<T, T> {
        private IdentityKeySelector() {
        }

        public T getKey(T value) {
            return value;
        }
    }
}

