/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.java;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.plan.BulkIterationPlanNode;
import org.apache.flink.optimizer.plan.NAryUnionPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.WorksetIterationPlanNode;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.testfunctions.IdentityMapper;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class IterationCompilerTest
extends CompilerTestBase {
    @Test
    public void testIdentityIteration() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(43);
            IterativeDataSet iteration = env.generateSequence(-4L, 1000L).iterate(100);
            iteration.closeWith((DataSet)iteration).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEmptyWorksetIteration() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(43);
            MapOperator input = env.generateSequence(1L, 20L).map((MapFunction)new MapFunction<Long, Tuple2<Long, Long>>(){

                public Tuple2<Long, Long> map(Long value) {
                    return null;
                }
            });
            DeltaIteration iter = input.iterateDelta((DataSet)input, 100, new int[]{0});
            iter.closeWith((DataSet)iter.getWorkset(), (DataSet)iter.getWorkset()).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIterationWithUnionRoot() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(43);
            IterativeDataSet iteration = env.generateSequence(-4L, 1000L).iterate(100);
            iteration.closeWith((DataSet)iteration.map(new IdentityMapper()).union((DataSet)iteration.map(new IdentityMapper()))).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            BulkIterationPlanNode iterNode = (BulkIterationPlanNode)sink.getInput().getSource();
            SingleInputPlanNode noop = (SingleInputPlanNode)iterNode.getRootOfStepFunction();
            NAryUnionPlanNode union = (NAryUnionPlanNode)noop.getInput().getSource();
            Assert.assertTrue((boolean)noop.isOnDynamicPath());
            Assert.assertTrue((noop.getCostWeight() >= 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)union.isOnDynamicPath());
            Assert.assertTrue((union.getCostWeight() >= 1 ? 1 : 0) != 0);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWorksetIterationWithUnionRoot() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(43);
            MapOperator input = env.generateSequence(1L, 20L).map((MapFunction)new MapFunction<Long, Tuple2<Long, Long>>(){

                public Tuple2<Long, Long> map(Long value) {
                    return null;
                }
            });
            DeltaIteration iter = input.iterateDelta((DataSet)input, 100, new int[]{0});
            iter.closeWith((DataSet)iter.getWorkset().map(new IdentityMapper()).union((DataSet)iter.getWorkset().map(new IdentityMapper())), (DataSet)iter.getWorkset().map(new IdentityMapper()).union((DataSet)iter.getWorkset().map(new IdentityMapper()))).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            WorksetIterationPlanNode iterNode = (WorksetIterationPlanNode)sink.getInput().getSource();
            SingleInputPlanNode nextWorksetNoop = (SingleInputPlanNode)iterNode.getNextWorkSetPlanNode();
            SingleInputPlanNode solutionDeltaNoop = (SingleInputPlanNode)iterNode.getSolutionSetDeltaPlanNode();
            NAryUnionPlanNode nextWorksetUnion = (NAryUnionPlanNode)nextWorksetNoop.getInput().getSource();
            NAryUnionPlanNode solutionDeltaUnion = (NAryUnionPlanNode)solutionDeltaNoop.getInput().getSource();
            Assert.assertTrue((boolean)nextWorksetNoop.isOnDynamicPath());
            Assert.assertTrue((nextWorksetNoop.getCostWeight() >= 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)solutionDeltaNoop.isOnDynamicPath());
            Assert.assertTrue((solutionDeltaNoop.getCostWeight() >= 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)nextWorksetUnion.isOnDynamicPath());
            Assert.assertTrue((nextWorksetUnion.getCostWeight() >= 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)solutionDeltaUnion.isOnDynamicPath());
            Assert.assertTrue((solutionDeltaUnion.getCostWeight() >= 1 ? 1 : 0) != 0);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

