/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.optimizer.dataproperties.MockDistribution;
import org.apache.flink.optimizer.dataproperties.MockPartitioner;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.junit.Assert;
import org.junit.Test;

public class RequestedGlobalPropertiesFilteringTest {
    private TupleTypeInfo<Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>> tupleInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test(expected=NullPointerException.class)
    public void testNullProps() {
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setAnyPartitioning(new FieldSet(new int[]{0, 1, 2}));
        rgProps.filterBySemanticProperties(null, 0);
    }

    @Test
    public void testEraseAll1() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setAnyPartitioning(new FieldSet(new int[]{0, 1, 2}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testEraseAll2() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"3;4"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setAnyPartitioning(new FieldSet(new int[]{0, 1, 2}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testHashPartitioningPreserved1() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"0;3;4"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setHashPartitioned(new FieldSet(new int[]{0, 3, 4}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getPartitionedFields());
        Assert.assertEquals((long)3L, (long)filtered.getPartitionedFields().size());
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(4)));
        Assert.assertNull((Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
        Assert.assertNull((Object)filtered.getOrdering());
    }

    @Test
    public void testHashPartitioningPreserved2() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"2->0;1->3;7->4"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setHashPartitioned(new FieldSet(new int[]{0, 3, 4}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getPartitionedFields());
        Assert.assertEquals((long)3L, (long)filtered.getPartitionedFields().size());
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(7)));
        Assert.assertNull((Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
        Assert.assertNull((Object)filtered.getOrdering());
    }

    @Test
    public void testHashPartitioningErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setHashPartitioned(new FieldSet(new int[]{0, 3, 4}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testAnyPartitioningPreserved1() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"0;3;4"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setAnyPartitioning(new FieldSet(new int[]{0, 3, 4}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.ANY_PARTITIONING, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getPartitionedFields());
        Assert.assertEquals((long)3L, (long)filtered.getPartitionedFields().size());
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(4)));
        Assert.assertNull((Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
        Assert.assertNull((Object)filtered.getOrdering());
    }

    @Test
    public void testAnyPartitioningPreserved2() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"2->0;1->3;7->4"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setAnyPartitioning(new FieldSet(new int[]{0, 3, 4}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.ANY_PARTITIONING, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getPartitionedFields());
        Assert.assertEquals((long)3L, (long)filtered.getPartitionedFields().size());
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filtered.getPartitionedFields().contains(Integer.valueOf(7)));
        Assert.assertNull((Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
        Assert.assertNull((Object)filtered.getOrdering());
    }

    @Test
    public void testAnyPartitioningErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setAnyPartitioning(new FieldSet(new int[]{0, 3, 4}));
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testRangePartitioningPreserved1() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"1;3;6"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(3), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setRangePartitioned(o);
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.RANGE_PARTITIONED, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getOrdering());
        Assert.assertEquals((long)3L, (long)filtered.getOrdering().getNumberOfFields());
        Assert.assertEquals((long)3L, (long)filtered.getOrdering().getFieldNumber(0).intValue());
        Assert.assertEquals((long)1L, (long)filtered.getOrdering().getFieldNumber(1).intValue());
        Assert.assertEquals((long)6L, (long)filtered.getOrdering().getFieldNumber(2).intValue());
        Assert.assertEquals(LongValue.class, (Object)filtered.getOrdering().getType(0));
        Assert.assertEquals(IntValue.class, (Object)filtered.getOrdering().getType(1));
        Assert.assertEquals(ByteValue.class, (Object)filtered.getOrdering().getType(2));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(0));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)filtered.getOrdering().getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(2));
        Assert.assertNull((Object)filtered.getPartitionedFields());
        Assert.assertNull((Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
    }

    @Test
    public void testRangePartitioningPreserved2() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"7->3;1->1;2->6"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(3), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setRangePartitioned(o);
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.RANGE_PARTITIONED, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getOrdering());
        Assert.assertEquals((long)3L, (long)filtered.getOrdering().getNumberOfFields());
        Assert.assertEquals((long)7L, (long)filtered.getOrdering().getFieldNumber(0).intValue());
        Assert.assertEquals((long)1L, (long)filtered.getOrdering().getFieldNumber(1).intValue());
        Assert.assertEquals((long)2L, (long)filtered.getOrdering().getFieldNumber(2).intValue());
        Assert.assertEquals(LongValue.class, (Object)filtered.getOrdering().getType(0));
        Assert.assertEquals(IntValue.class, (Object)filtered.getOrdering().getType(1));
        Assert.assertEquals(ByteValue.class, (Object)filtered.getOrdering().getType(2));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(0));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)filtered.getOrdering().getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(2));
        Assert.assertNull((Object)filtered.getPartitionedFields());
        Assert.assertNull((Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
    }

    @Test
    public void testRangePartitioningPreserved3() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"7->3;1->1;2->6"}, null, null, this.tupleInfo, this.tupleInfo);
        MockDistribution dd = new MockDistribution();
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(3), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setRangePartitioned(o, (DataDistribution)dd);
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertEquals((Object)PartitioningProperty.RANGE_PARTITIONED, (Object)filtered.getPartitioning());
        Assert.assertNotNull((Object)filtered.getOrdering());
        Assert.assertEquals((long)3L, (long)filtered.getOrdering().getNumberOfFields());
        Assert.assertEquals((long)7L, (long)filtered.getOrdering().getFieldNumber(0).intValue());
        Assert.assertEquals((long)1L, (long)filtered.getOrdering().getFieldNumber(1).intValue());
        Assert.assertEquals((long)2L, (long)filtered.getOrdering().getFieldNumber(2).intValue());
        Assert.assertEquals(LongValue.class, (Object)filtered.getOrdering().getType(0));
        Assert.assertEquals(IntValue.class, (Object)filtered.getOrdering().getType(1));
        Assert.assertEquals(ByteValue.class, (Object)filtered.getOrdering().getType(2));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(0));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)filtered.getOrdering().getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(2));
        Assert.assertNotNull((Object)filtered.getDataDistribution());
        Assert.assertEquals((Object)dd, (Object)filtered.getDataDistribution());
        Assert.assertNull((Object)filtered.getPartitionedFields());
        Assert.assertNull((Object)filtered.getCustomPartitioner());
    }

    @Test
    public void testRangePartitioningErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(3), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setRangePartitioned(o);
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testCustomPartitioningErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"0;1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setCustomPartitioned(new FieldSet(new int[]{0, 1, 2}), (Partitioner)new MockPartitioner());
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testRandomDistributionErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"0;1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setRandomPartitioning();
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testReplicationErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"0;1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setFullyReplicated();
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testRebalancingErased() {
        SingleInputSemanticProperties sProp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProp, (String[])new String[]{"0;1;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties rgProps = new RequestedGlobalProperties();
        rgProps.setForceRebalancing();
        RequestedGlobalProperties filtered = rgProps.filterBySemanticProperties((SemanticProperties)sProp, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testDualHashPartitioningPreserved() {
        DualInputSemanticProperties dprops = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dprops, (String[])new String[]{"0;2;4"}, (String[])new String[]{"1->3;4->6;3->7"}, null, null, null, null, this.tupleInfo, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties gprops1 = new RequestedGlobalProperties();
        RequestedGlobalProperties gprops2 = new RequestedGlobalProperties();
        gprops1.setHashPartitioned(new FieldSet(new int[]{2, 0, 4}));
        gprops2.setHashPartitioned(new FieldSet(new int[]{3, 6, 7}));
        RequestedGlobalProperties filtered1 = gprops1.filterBySemanticProperties((SemanticProperties)dprops, 0);
        RequestedGlobalProperties filtered2 = gprops2.filterBySemanticProperties((SemanticProperties)dprops, 1);
        Assert.assertNotNull((Object)filtered1);
        Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)filtered1.getPartitioning());
        Assert.assertNotNull((Object)filtered1.getPartitionedFields());
        Assert.assertEquals((long)3L, (long)filtered1.getPartitionedFields().size());
        Assert.assertTrue((boolean)filtered1.getPartitionedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered1.getPartitionedFields().contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filtered1.getPartitionedFields().contains(Integer.valueOf(4)));
        Assert.assertNull((Object)filtered1.getOrdering());
        Assert.assertNull((Object)filtered1.getCustomPartitioner());
        Assert.assertNull((Object)filtered1.getDataDistribution());
        Assert.assertNotNull((Object)filtered2);
        Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)filtered2.getPartitioning());
        Assert.assertNotNull((Object)filtered2.getPartitionedFields());
        Assert.assertEquals((long)3L, (long)filtered2.getPartitionedFields().size());
        Assert.assertTrue((boolean)filtered2.getPartitionedFields().contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)filtered2.getPartitionedFields().contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)filtered2.getPartitionedFields().contains(Integer.valueOf(4)));
        Assert.assertNull((Object)filtered2.getOrdering());
        Assert.assertNull((Object)filtered2.getCustomPartitioner());
        Assert.assertNull((Object)filtered2.getDataDistribution());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInvalidInputIndex() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedGlobalProperties gprops = new RequestedGlobalProperties();
        gprops.setHashPartitioned(new FieldSet(new int[]{0, 1}));
        gprops.filterBySemanticProperties((SemanticProperties)sprops, 1);
    }
}

