/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import java.util.Set;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.MockPartitioner;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class GlobalPropertiesFilteringTest {
    private TupleTypeInfo<Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>> tupleInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test
    public void testAllErased1() {
        SingleInputSemanticProperties semProps = new SingleInputSemanticProperties();
        GlobalProperties gprops = new GlobalProperties();
        gprops.setHashPartitioned(new FieldList(new int[]{0, 1}));
        gprops.addUniqueFieldCombination(new FieldSet(new int[]{3, 4}));
        gprops.addUniqueFieldCombination(new FieldSet(new int[]{5, 6}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)semProps, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANDOM_PARTITIONED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningFields());
        Assert.assertNull((Object)result.getPartitioningOrdering());
        Assert.assertNull((Object)result.getUniqueFieldCombination());
    }

    @Test
    public void testAllErased2() {
        SingleInputSemanticProperties semProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)semProps, (String[])new String[]{"2"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setHashPartitioned(new FieldList(new int[]{0, 1}));
        gprops.addUniqueFieldCombination(new FieldSet(new int[]{3, 4}));
        gprops.addUniqueFieldCombination(new FieldSet(new int[]{5, 6}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)semProps, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANDOM_PARTITIONED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningFields());
        Assert.assertNull((Object)result.getPartitioningOrdering());
        Assert.assertNull((Object)result.getUniqueFieldCombination());
    }

    @Test
    public void testHashPartitioningPreserved1() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1;4"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setHashPartitioned(new FieldList(new int[]{0, 1, 4}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)3L, (long)pFields.size());
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(4)));
    }

    @Test
    public void testHashPartitioningPreserved2() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0->1; 1->2; 4->3"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setHashPartitioned(new FieldList(new int[]{0, 1, 4}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.HASH_PARTITIONED, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)3L, (long)pFields.size());
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(3)));
    }

    @Test
    public void testHashPartitioningErased() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setHashPartitioned(new FieldList(new int[]{0, 1, 4}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANDOM_PARTITIONED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningFields());
    }

    @Test
    public void testAnyPartitioningPreserved1() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1;4"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setAnyPartitioning(new FieldList(new int[]{0, 1, 4}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.ANY_PARTITIONING, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)3L, (long)pFields.size());
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(4)));
    }

    @Test
    public void testAnyPartitioningPreserved2() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0->1; 1->2; 4->3"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setAnyPartitioning(new FieldList(new int[]{0, 1, 4}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.ANY_PARTITIONING, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)3L, (long)pFields.size());
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(3)));
    }

    @Test
    public void testAnyPartitioningErased() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setAnyPartitioning(new FieldList(new int[]{0, 1, 4}));
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANDOM_PARTITIONED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningFields());
    }

    @Test
    public void testCustomPartitioningPreserved1() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1;4"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        MockPartitioner myP = new MockPartitioner();
        gprops.setCustomPartitioned(new FieldList(new int[]{0, 4}), (Partitioner)myP);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.CUSTOM_PARTITIONING, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)2L, (long)pFields.size());
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(4)));
        Assert.assertEquals((Object)myP, (Object)result.getCustomPartitioner());
    }

    @Test
    public void testCustomPartitioningPreserved2() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0->1; 1->2; 4->3"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        MockPartitioner myP = new MockPartitioner();
        gprops.setCustomPartitioned(new FieldList(new int[]{0, 4}), (Partitioner)myP);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.CUSTOM_PARTITIONING, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)2L, (long)pFields.size());
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)pFields.contains(Integer.valueOf(3)));
        Assert.assertEquals((Object)myP, (Object)result.getCustomPartitioner());
    }

    @Test
    public void testCustomPartitioningErased() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        MockPartitioner myP = new MockPartitioner();
        gprops.setCustomPartitioned(new FieldList(new int[]{0, 4}), (Partitioner)myP);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANDOM_PARTITIONED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningFields());
        Assert.assertNull((Object)result.getCustomPartitioner());
    }

    @Test
    public void testRangePartitioningPreserved1() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"1;2;5"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(2), StringValue.class, Order.ASCENDING);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setRangePartitioned(o);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANGE_PARTITIONED, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)3L, (long)pFields.size());
        Assert.assertEquals((long)1L, (long)pFields.get(0).intValue());
        Assert.assertEquals((long)5L, (long)pFields.get(1).intValue());
        Assert.assertEquals((long)2L, (long)pFields.get(2).intValue());
        Ordering pOrder = result.getPartitioningOrdering();
        Assert.assertEquals((long)3L, (long)pOrder.getNumberOfFields());
        Assert.assertEquals((long)1L, (long)pOrder.getFieldNumber(0).intValue());
        Assert.assertEquals((long)5L, (long)pOrder.getFieldNumber(1).intValue());
        Assert.assertEquals((long)2L, (long)pOrder.getFieldNumber(2).intValue());
        Assert.assertEquals((Object)Order.ASCENDING, (Object)pOrder.getOrder(0));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)pOrder.getOrder(1));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)pOrder.getOrder(2));
        Assert.assertEquals(IntValue.class, (Object)pOrder.getType(0));
        Assert.assertEquals(LongValue.class, (Object)pOrder.getType(1));
        Assert.assertEquals(StringValue.class, (Object)pOrder.getType(2));
    }

    @Test
    public void testRangePartitioningPreserved2() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"1->3; 2->0; 5->1"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(2), StringValue.class, Order.ASCENDING);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setRangePartitioned(o);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANGE_PARTITIONED, (Object)result.getPartitioning());
        FieldList pFields = result.getPartitioningFields();
        Assert.assertEquals((long)3L, (long)pFields.size());
        Assert.assertEquals((long)3L, (long)pFields.get(0).intValue());
        Assert.assertEquals((long)1L, (long)pFields.get(1).intValue());
        Assert.assertEquals((long)0L, (long)pFields.get(2).intValue());
        Ordering pOrder = result.getPartitioningOrdering();
        Assert.assertEquals((long)3L, (long)pOrder.getNumberOfFields());
        Assert.assertEquals((long)3L, (long)pOrder.getFieldNumber(0).intValue());
        Assert.assertEquals((long)1L, (long)pOrder.getFieldNumber(1).intValue());
        Assert.assertEquals((long)0L, (long)pOrder.getFieldNumber(2).intValue());
        Assert.assertEquals((Object)Order.ASCENDING, (Object)pOrder.getOrder(0));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)pOrder.getOrder(1));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)pOrder.getOrder(2));
        Assert.assertEquals(IntValue.class, (Object)pOrder.getType(0));
        Assert.assertEquals(LongValue.class, (Object)pOrder.getType(1));
        Assert.assertEquals(StringValue.class, (Object)pOrder.getType(2));
    }

    @Test
    public void testRangePartitioningErased() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"1;5"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(5), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(2), StringValue.class, Order.ASCENDING);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setRangePartitioned(o);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.RANDOM_PARTITIONED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningOrdering());
        Assert.assertNull((Object)result.getPartitioningFields());
    }

    @Test
    public void testRebalancingPreserved() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0->1; 1->2; 4->3"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setForcedRebalanced();
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertEquals((Object)PartitioningProperty.FORCED_REBALANCED, (Object)result.getPartitioning());
        Assert.assertNull((Object)result.getPartitioningFields());
    }

    @Test
    public void testUniqueFieldGroupsPreserved1() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1;2;3;4"}, null, null, this.tupleInfo, this.tupleInfo);
        FieldSet set1 = new FieldSet(new int[]{0, 1, 2});
        FieldSet set2 = new FieldSet(new int[]{3, 4});
        FieldSet set3 = new FieldSet(new int[]{4, 5, 6, 7});
        GlobalProperties gprops = new GlobalProperties();
        gprops.addUniqueFieldCombination(set1);
        gprops.addUniqueFieldCombination(set2);
        gprops.addUniqueFieldCombination(set3);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Set unique = result.getUniqueFieldCombination();
        FieldSet expected1 = new FieldSet(new int[]{0, 1, 2});
        FieldSet expected2 = new FieldSet(new int[]{3, 4});
        Assert.assertTrue((unique.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)unique.contains(expected1));
        Assert.assertTrue((boolean)unique.contains(expected2));
    }

    @Test
    public void testUniqueFieldGroupsPreserved2() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0->5;1;2;3->6;4"}, null, null, this.tupleInfo, this.tupleInfo);
        FieldSet set1 = new FieldSet(new int[]{0, 1, 2});
        FieldSet set2 = new FieldSet(new int[]{3, 4});
        FieldSet set3 = new FieldSet(new int[]{4, 5, 6, 7});
        GlobalProperties gprops = new GlobalProperties();
        gprops.addUniqueFieldCombination(set1);
        gprops.addUniqueFieldCombination(set2);
        gprops.addUniqueFieldCombination(set3);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Set unique = result.getUniqueFieldCombination();
        FieldSet expected1 = new FieldSet(new int[]{1, 2, 5});
        FieldSet expected2 = new FieldSet(new int[]{4, 6});
        Assert.assertTrue((unique.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)unique.contains(expected1));
        Assert.assertTrue((boolean)unique.contains(expected2));
    }

    @Test
    public void testUniqueFieldGroupsErased() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0; 3; 5; 6; 7"}, null, null, this.tupleInfo, this.tupleInfo);
        FieldSet set1 = new FieldSet(new int[]{0, 1, 2});
        FieldSet set2 = new FieldSet(new int[]{3, 4});
        FieldSet set3 = new FieldSet(new int[]{4, 5, 6, 7});
        GlobalProperties gprops = new GlobalProperties();
        gprops.addUniqueFieldCombination(set1);
        gprops.addUniqueFieldCombination(set2);
        gprops.addUniqueFieldCombination(set3);
        GlobalProperties result = gprops.filterBySemanticProperties((SemanticProperties)sprops, 0);
        Assert.assertNull((Object)result.getUniqueFieldCombination());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInvalidInputIndex() {
        SingleInputSemanticProperties sprops = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sprops, (String[])new String[]{"0;1"}, null, null, this.tupleInfo, this.tupleInfo);
        GlobalProperties gprops = new GlobalProperties();
        gprops.setHashPartitioned(new FieldList(new int[]{0, 1}));
        gprops.filterBySemanticProperties((SemanticProperties)sprops, 1);
    }
}

