/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.dag.CoGroupNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CoGroupNodeTest {
    @Test
    public void testGetSemanticProperties() {
        DualInputSemanticProperties origProps = new DualInputSemanticProperties();
        origProps.addForwardedField(0, 0, 1);
        origProps.addForwardedField(0, 2, 2);
        origProps.addForwardedField(0, 3, 4);
        origProps.addForwardedField(0, 6, 0);
        origProps.addReadFields(0, new FieldSet(new int[]{0, 2, 4, 7}));
        origProps.addForwardedField(1, 1, 2);
        origProps.addForwardedField(1, 2, 8);
        origProps.addForwardedField(1, 3, 7);
        origProps.addForwardedField(1, 6, 6);
        origProps.addReadFields(1, new FieldSet(new int[]{1, 3, 4}));
        CoGroupOperatorBase op = (CoGroupOperatorBase)Mockito.mock(CoGroupOperatorBase.class);
        Mockito.when((Object)op.getSemanticProperties()).thenReturn((Object)origProps);
        Mockito.when((Object)op.getKeyColumns(0)).thenReturn((Object)new int[]{3, 2});
        Mockito.when((Object)op.getKeyColumns(1)).thenReturn((Object)new int[]{6, 3});
        Mockito.when((Object)op.getParameters()).thenReturn((Object)new Configuration());
        CoGroupNode node = new CoGroupNode(op);
        SemanticProperties filteredProps = node.getSemanticPropertiesForLocalPropertyFiltering();
        Assert.assertTrue((filteredProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((filteredProps.getForwardingTargetFields(0, 3).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((filteredProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(0, 1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(0, 2) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(0, 4) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getReadFields(0).size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(0).contains(Integer.valueOf(7)));
        Assert.assertTrue((filteredProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingTargetFields(1, 3).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(7)));
        Assert.assertTrue((filteredProps.getForwardingTargetFields(1, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getForwardingTargetFields(1, 6).contains(Integer.valueOf(6)));
        Assert.assertTrue((filteredProps.getForwardingSourceField(1, 2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(1, 8) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(1, 7) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getForwardingSourceField(1, 6) == 6 ? 1 : 0) != 0);
        Assert.assertTrue((filteredProps.getReadFields(1).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filteredProps.getReadFields(1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(1).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)filteredProps.getReadFields(1).contains(Integer.valueOf(4)));
    }
}

