/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.IdentityGroupReducerCombinable;
import org.apache.flink.optimizer.testfunctions.IdentityMapper;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.junit.Assert;
import org.junit.Test;

public class SortPartialReuseTest
extends CompilerTestBase {
    @Test
    public void testPartialPartitioningReuse() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            ((GroupReduceOperator)((MapOperator)input.partitionByHash(new int[]{0}).map(new IdentityMapper()).withForwardedFields(new String[]{"0", "1", "2"})).groupBy(new int[]{0, 1}).reduceGroup(new IdentityGroupReducerCombinable()).withForwardedFields(new String[]{"0", "1", "2"})).groupBy(new int[]{0}).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer2 = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode reducer1 = (SingleInputPlanNode)reducer2.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)reducer2.getInput().getShipStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)reducer2.getInput().getLocalStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)reducer1.getInput().getShipStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer1.getInput().getLocalStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningNotReused() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            ((GroupReduceOperator)((MapOperator)input.partitionCustom((Partitioner)new Partitioner<Long>(){

                public int partition(Long key, int numPartitions) {
                    return 0;
                }
            }, 0).map(new IdentityMapper()).withForwardedFields(new String[]{"0", "1", "2"})).groupBy(new int[]{0, 1}).reduceGroup(new IdentityGroupReducerCombinable()).withForwardedFields(new String[]{"0", "1", "2"})).groupBy(new int[]{1}).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer2 = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer2.getInput().getSource();
            SingleInputPlanNode reducer1 = (SingleInputPlanNode)combiner.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)reducer2.getInput().getShipStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer2.getInput().getLocalStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)combiner.getInput().getLocalStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)reducer1.getInput().getShipStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer1.getInput().getLocalStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

