/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.NAryUnionPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class PropertyDataSourceTest
extends CompilerTestBase {
    private List<Tuple3<Long, SomePojo, String>> tuple3PojoData = new ArrayList<Tuple3<Long, SomePojo, String>>();
    private TupleTypeInfo<Tuple3<Long, SomePojo, String>> tuple3PojoType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.createTypeInfo(SomePojo.class), BasicTypeInfo.STRING_TYPE_INFO});

    @Test
    public void checkSinglePartitionedSource1() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedSource2() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{1, 0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{0, 1})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedSource3() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("*");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{0, 1, 2, 3, 4})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedSource4() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{1, 2, 3})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedSource5() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1.stringField");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(3))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedSource6() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1.intField; f2");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{2, 4})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedSource7() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy("byDate", new int[]{1, 0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{0, 1})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((gprops.getCustomPartitioner() != null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource1() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{0}).splitsGroupedBy(new int[]{0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource2() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{0}).splitsGroupedBy(new int[]{1, 0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(new int[]{0, 1})));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource3() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{1}).splitsGroupedBy(new int[]{0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(1))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource4() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{0, 1}).splitsGroupedBy(new int[]{0});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{0, 1})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource5() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f2").splitsGroupedBy("f2");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(4))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(4))));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource6() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1.intField").splitsGroupedBy("f0; f1.intField");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(2))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(new int[]{0, 2})));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource7() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1.intField").splitsGroupedBy("f1");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(2))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(new int[]{1, 2, 3})));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedGroupedSource8() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1").splitsGroupedBy("f1.stringField");
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{1, 2, 3})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource1() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{1}).splitsOrderedBy(new int[]{1}, new Order[]{Order.ASCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(1))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(1))));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource2() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{1}).splitsOrderedBy(new int[]{1, 0}, new Order[]{Order.ASCENDING, Order.DESCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(1))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(new int[]{1, 0})));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource3() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{0}).splitsOrderedBy(new int[]{1}, new Order[]{Order.ASCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource4() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.readCsvFile("/some/path").types(Long.class, String.class);
        data.getSplitDataProperties().splitsPartitionedBy(new int[]{0, 1}).splitsOrderedBy(new int[]{1}, new Order[]{Order.DESCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{0, 1})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource5() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1.intField").splitsOrderedBy("f0; f1.intField", new Order[]{Order.ASCENDING, Order.DESCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(2))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(new int[]{0, 2})));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource6() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1.intField").splitsOrderedBy("f1", new Order[]{Order.DESCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(2))));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(lprops.getGroupedFields().toArray()).equals((Object)new FieldSet(new int[]{1, 2, 3})));
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkSinglePartitionedOrderedSource7() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data = env.fromCollection(this.tuple3PojoData, this.tuple3PojoType);
        data.getSplitDataProperties().splitsPartitionedBy("f1").splitsOrderedBy("f1.stringField", new Order[]{Order.ASCENDING});
        data.output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode = (SourcePlanNode)sinkNode.getPredecessor();
        GlobalProperties gprops = sourceNode.getGlobalProperties();
        LocalProperties lprops = sourceNode.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops.getPartitioningFields().toArray()).equals((Object)new FieldSet(new int[]{1, 2, 3})));
        Assert.assertTrue((gprops.getPartitioning() == PartitioningProperty.ANY_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops.getOrdering() == null ? 1 : 0) != 0);
    }

    @Test
    public void checkCoPartitionedSources1() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data1 = env.readCsvFile("/some/path").types(Long.class, String.class);
        data1.getSplitDataProperties().splitsPartitionedBy("byDate", new int[]{0});
        DataSource data2 = env.readCsvFile("/some/path").types(Long.class, String.class);
        data2.getSplitDataProperties().splitsPartitionedBy("byDate", new int[]{0});
        data1.union((DataSet)data2).output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode1 = (SourcePlanNode)((Channel)((NAryUnionPlanNode)sinkNode.getPredecessor()).getListOfInputs().get(0)).getSource();
        SourcePlanNode sourceNode2 = (SourcePlanNode)((Channel)((NAryUnionPlanNode)sinkNode.getPredecessor()).getListOfInputs().get(1)).getSource();
        GlobalProperties gprops1 = sourceNode1.getGlobalProperties();
        LocalProperties lprops1 = sourceNode1.getLocalProperties();
        GlobalProperties gprops2 = sourceNode2.getGlobalProperties();
        LocalProperties lprops2 = sourceNode2.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops1.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops1.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops1.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops1.getOrdering() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(gprops2.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops2.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops2.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops2.getOrdering() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)gprops1.getCustomPartitioner().equals(gprops2.getCustomPartitioner()));
    }

    @Test
    public void checkCoPartitionedSources2() {
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment();
        env.setParallelism(8);
        DataSource data1 = env.readCsvFile("/some/path").types(Long.class, String.class);
        data1.getSplitDataProperties().splitsPartitionedBy("byCountry", new int[]{0});
        DataSource data2 = env.readCsvFile("/some/path").types(Long.class, String.class);
        data2.getSplitDataProperties().splitsPartitionedBy("byDate", new int[]{0});
        data1.union((DataSet)data2).output((OutputFormat)new DiscardingOutputFormat());
        JavaPlan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileNoStats((Plan)plan);
        SinkPlanNode sinkNode = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        SourcePlanNode sourceNode1 = (SourcePlanNode)((Channel)((NAryUnionPlanNode)sinkNode.getPredecessor()).getListOfInputs().get(0)).getSource();
        SourcePlanNode sourceNode2 = (SourcePlanNode)((Channel)((NAryUnionPlanNode)sinkNode.getPredecessor()).getListOfInputs().get(1)).getSource();
        GlobalProperties gprops1 = sourceNode1.getGlobalProperties();
        LocalProperties lprops1 = sourceNode1.getLocalProperties();
        GlobalProperties gprops2 = sourceNode2.getGlobalProperties();
        LocalProperties lprops2 = sourceNode2.getLocalProperties();
        Assert.assertTrue((boolean)new FieldSet(gprops1.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops1.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops1.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops1.getOrdering() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new FieldSet(gprops2.getPartitioningFields().toArray()).equals((Object)new FieldSet(Integer.valueOf(0))));
        Assert.assertTrue((gprops2.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING ? 1 : 0) != 0);
        Assert.assertTrue((lprops2.getGroupedFields() == null ? 1 : 0) != 0);
        Assert.assertTrue((lprops2.getOrdering() == null ? 1 : 0) != 0);
        Assert.assertTrue((!gprops1.getCustomPartitioner().equals(gprops2.getCustomPartitioner()) ? 1 : 0) != 0);
    }

    public static class SomePojo {
        public double doubleField;
        public int intField;
        public String stringField;
    }
}

