/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.testfunctions.DummyFlatJoinFunction;
import org.apache.flink.optimizer.testfunctions.IdentityKeyExtractor;
import org.apache.flink.optimizer.testfunctions.IdentityMapper;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class NestedIterationsTest
extends CompilerTestBase {
    @Test
    public void testRejectNestedBulkIterations() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource data = env.generateSequence(1L, 100L);
            IterativeDataSet outerIteration = data.iterate(100);
            IterativeDataSet innerIteration = outerIteration.map(new IdentityMapper()).iterate(100);
            DataSet innerResult = innerIteration.closeWith((DataSet)innerIteration.map(new IdentityMapper()));
            DataSet outerResult = outerIteration.closeWith((DataSet)innerResult.map(new IdentityMapper()));
            outerResult.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            try {
                this.compileNoStats((Plan)p);
            }
            catch (CompilerException e) {
                Assert.assertTrue((e.getMessage().toLowerCase().indexOf("nested iterations") != -1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRejectNestedWorksetIterations() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource data = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DeltaIteration outerIteration = data.iterateDelta((DataSet)data, 100, new int[]{0});
            MapOperator inOuter = outerIteration.getWorkset().map(new IdentityMapper());
            DeltaIteration innerIteration = inOuter.iterateDelta((DataSet)inOuter, 100, new int[]{0});
            MapOperator inInner = innerIteration.getWorkset().map(new IdentityMapper());
            MapOperator innerResult = innerIteration.closeWith((DataSet)inInner, (DataSet)inInner).map(new IdentityMapper());
            DataSet outerResult = outerIteration.closeWith((DataSet)innerResult, (DataSet)innerResult);
            outerResult.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            try {
                this.compileNoStats((Plan)p);
            }
            catch (CompilerException e) {
                Assert.assertTrue((e.getMessage().toLowerCase().indexOf("nested iterations") != -1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBulkIterationInClosure() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource data1 = env.generateSequence(1L, 100L);
            DataSource data2 = env.generateSequence(1L, 100L);
            IterativeDataSet firstIteration = data1.iterate(100);
            DataSet firstResult = firstIteration.closeWith((DataSet)firstIteration.map(new IdentityMapper()));
            IterativeDataSet mainIteration = data2.map(new IdentityMapper()).iterate(100);
            JoinOperator.EquiJoin joined = mainIteration.join(firstResult).where(new IdentityKeyExtractor()).equalTo(new IdentityKeyExtractor()).with(new DummyFlatJoinFunction());
            DataSet mainResult = mainIteration.closeWith((DataSet)joined);
            mainResult.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeltaIterationInClosure() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource data1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource data2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DeltaIteration firstIteration = data1.iterateDelta((DataSet)data1, 100, new int[]{0});
            MapOperator inFirst = firstIteration.getWorkset().map(new IdentityMapper());
            MapOperator firstResult = firstIteration.closeWith((DataSet)inFirst, (DataSet)inFirst).map(new IdentityMapper());
            DeltaIteration mainIteration = data2.iterateDelta((DataSet)data2, 100, new int[]{0});
            JoinOperator.ProjectJoin joined = mainIteration.getWorkset().join((DataSet)firstResult).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{0});
            DataSet mainResult = mainIteration.closeWith((DataSet)joined, (DataSet)joined);
            mainResult.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

