/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.IdentityCoGrouper;
import org.apache.flink.optimizer.testfunctions.IdentityGroupReducer;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.junit.Assert;
import org.junit.Test;

public class GroupOrderTest
extends CompilerTestBase {
    @Test
    public void testReduceWithGroupOrder() {
        OptimizedPlan oPlan;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(8);
        DataSource set1 = env.readCsvFile("/tmp/fake.csv").types(Long.class, Long.class, Long.class, Long.class);
        ((GroupReduceOperator)set1.groupBy(new int[]{1}).sortGroup(3, Order.DESCENDING).reduceGroup(new IdentityGroupReducer()).name("Reduce")).output((OutputFormat)new DiscardingOutputFormat()).name("Sink");
        JavaPlan plan = env.createProgramPlan();
        try {
            oPlan = this.compileNoStats((Plan)plan);
        }
        catch (CompilerException ce) {
            ce.printStackTrace();
            Assert.fail((String)"The pact compiler is unable to compile this plan correctly.");
            return;
        }
        CompilerTestBase.OptimizerPlanNodeResolver resolver = GroupOrderTest.getOptimizerPlanNodeResolver(oPlan);
        SinkPlanNode sinkNode = (SinkPlanNode)resolver.getNode("Sink");
        SingleInputPlanNode reducer = (SingleInputPlanNode)resolver.getNode("Reduce");
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sinkNode.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)reducer.getInput().getShipStrategy());
        Channel c = reducer.getInput();
        Assert.assertEquals((Object)LocalStrategy.SORT, (Object)c.getLocalStrategy());
        FieldList ship = new FieldList(1);
        FieldList local = new FieldList(new int[]{1, 3});
        Assert.assertEquals((Object)ship, (Object)c.getShipStrategyKeys());
        Assert.assertEquals((Object)local, (Object)c.getLocalStrategyKeys());
        Assert.assertTrue((c.getLocalStrategySortOrder()[0] == reducer.getSortOrders(0)[0] ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)c.getLocalStrategySortOrder()[1]);
    }

    @Test
    public void testCoGroupWithGroupOrder() {
        OptimizedPlan oPlan;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(8);
        DataSource set1 = env.readCsvFile("/tmp/fake1.csv").types(Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class);
        DataSource set2 = env.readCsvFile("/tmp/fake2.csv").types(Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class);
        ((CoGroupOperator)set1.coGroup((DataSet)set2).where(new int[]{3, 0}).equalTo(new int[]{6, 0}).sortFirstGroup(5, Order.DESCENDING).sortSecondGroup(1, Order.DESCENDING).sortSecondGroup(4, Order.ASCENDING).with(new IdentityCoGrouper()).name("CoGroup")).output((OutputFormat)new DiscardingOutputFormat()).name("Sink");
        JavaPlan plan = env.createProgramPlan();
        try {
            oPlan = this.compileNoStats((Plan)plan);
        }
        catch (CompilerException ce) {
            ce.printStackTrace();
            Assert.fail((String)"The pact compiler is unable to compile this plan correctly.");
            return;
        }
        CompilerTestBase.OptimizerPlanNodeResolver resolver = GroupOrderTest.getOptimizerPlanNodeResolver(oPlan);
        SinkPlanNode sinkNode = (SinkPlanNode)resolver.getNode("Sink");
        DualInputPlanNode coGroupNode = (DualInputPlanNode)resolver.getNode("CoGroup");
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sinkNode.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)coGroupNode.getInput1().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)coGroupNode.getInput2().getShipStrategy());
        Channel c1 = coGroupNode.getInput1();
        Channel c2 = coGroupNode.getInput2();
        Assert.assertEquals((Object)LocalStrategy.SORT, (Object)c1.getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.SORT, (Object)c2.getLocalStrategy());
        FieldList ship1 = new FieldList(new int[]{3, 0});
        FieldList ship2 = new FieldList(new int[]{6, 0});
        FieldList local1 = new FieldList(new int[]{3, 0, 5});
        FieldList local2 = new FieldList(new int[]{6, 0, 1, 4});
        Assert.assertEquals((Object)ship1, (Object)c1.getShipStrategyKeys());
        Assert.assertEquals((Object)ship2, (Object)c2.getShipStrategyKeys());
        Assert.assertEquals((Object)local1, (Object)c1.getLocalStrategyKeys());
        Assert.assertEquals((Object)local2, (Object)c2.getLocalStrategyKeys());
        Assert.assertTrue((c1.getLocalStrategySortOrder()[0] == coGroupNode.getSortOrders()[0] ? 1 : 0) != 0);
        Assert.assertTrue((c1.getLocalStrategySortOrder()[1] == coGroupNode.getSortOrders()[1] ? 1 : 0) != 0);
        Assert.assertTrue((c2.getLocalStrategySortOrder()[0] == coGroupNode.getSortOrders()[0] ? 1 : 0) != 0);
        Assert.assertTrue((c2.getLocalStrategySortOrder()[1] == coGroupNode.getSortOrders()[1] ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)c1.getLocalStrategySortOrder()[2]);
        Assert.assertEquals((Object)false, (Object)c2.getLocalStrategySortOrder()[2]);
        Assert.assertEquals((Object)true, (Object)c2.getLocalStrategySortOrder()[3]);
    }
}

