/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.operatorstatistics.heavyhitters;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.frequency.CountMinSketch;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.HeavyHitter;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.HeavyHitterMergeException;

public class CountMinHeavyHitter
implements HeavyHitter,
Serializable {
    private transient CountMinSketch countMinSketch;
    private HashMap<Object, Long> heavyHitters;
    private double fraction;
    private double error;
    private long cardinality;

    public CountMinHeavyHitter(double fraction, double error, double confidence, int seed) {
        this.countMinSketch = new CountMinSketch(error, confidence, seed);
        this.error = error;
        this.cardinality = 0L;
        this.fraction = fraction;
        this.heavyHitters = new HashMap();
    }

    public CountMinHeavyHitter(CountMinSketch countMinSketch, double fraction) {
        this.countMinSketch = countMinSketch;
        this.error = countMinSketch.getRelativeError();
        this.cardinality = 0L;
        this.fraction = fraction;
        this.heavyHitters = new HashMap();
    }

    @Override
    public void addObject(Object o) {
        ++this.cardinality;
        if (o instanceof Long) {
            this.countMinSketch.add(((Long)o).longValue(), 1L);
        } else {
            this.countMinSketch.add((long)MurmurHash.hash((Object)o), 1L);
        }
        this.updateHeavyHitters(o);
    }

    private void updateHeavyHitters(Object item) {
        long minFrequency = (long)Math.ceil((double)this.cardinality * this.fraction);
        long estimateCount = this.estimateCount(item);
        if (estimateCount >= minFrequency) {
            this.heavyHitters.put(item, estimateCount);
        }
        if (this.cardinality % (long)Math.ceil(1.0 / this.error) == 0L) {
            this.removeNonFrequent(minFrequency);
        }
    }

    private void removeNonFrequent(long minFrequency) {
        Iterator<Map.Entry<Object, Long>> it = this.heavyHitters.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() >= minFrequency) continue;
            it.remove();
        }
    }

    public long estimateCount(Object item) {
        if (item instanceof Long) {
            return this.countMinSketch.estimateCount(((Long)item).longValue());
        }
        return this.countMinSketch.estimateCount((long)MurmurHash.hash((Object)item));
    }

    @Override
    public void merge(HeavyHitter toMerge) throws CMHeavyHitterMergeException {
        try {
            CountMinHeavyHitter cmToMerge = (CountMinHeavyHitter)toMerge;
            if (this.fraction != cmToMerge.fraction) {
                throw new CMHeavyHitterMergeException("The fraction for both heavy hitters must be the same");
            }
            this.countMinSketch = CountMinSketch.merge((CountMinSketch[])new CountMinSketch[]{this.countMinSketch, cmToMerge.countMinSketch});
            HashMap<Object, Long> mergedHeavyHitters = new HashMap<Object, Long>();
            for (Map.Entry<Object, Long> entry : this.heavyHitters.entrySet()) {
                mergedHeavyHitters.put(entry.getKey(), this.estimateCount(entry.getKey()));
            }
            for (Map.Entry<Object, Long> entry : cmToMerge.heavyHitters.entrySet()) {
                if (mergedHeavyHitters.containsKey(entry.getKey())) continue;
                mergedHeavyHitters.put(entry.getKey(), this.estimateCount(entry.getKey()));
            }
            this.heavyHitters = mergedHeavyHitters;
            this.cardinality += cmToMerge.cardinality;
        }
        catch (ClassCastException ex) {
            throw new CMHeavyHitterMergeException("Both heavy hitter objects must belong to the same class");
        }
        catch (Exception ex) {
            throw new CMHeavyHitterMergeException("Cannot merge count min sketches: " + ex.getMessage());
        }
    }

    @Override
    public HashMap<Object, Long> getHeavyHitters() {
        long minFrequency = (long)Math.ceil((double)this.cardinality * this.fraction);
        this.removeNonFrequent(minFrequency);
        return this.heavyHitters;
    }

    @Override
    public String toString() {
        String out = "";
        HashMap<Object, Long> heavyHitters = this.getHeavyHitters();
        for (Map.Entry entry : heavyHitters.entrySet()) {
            out = out + entry.getKey().toString() + " -> estimated freq. " + entry.getValue() + "\n";
        }
        return out;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(CountMinSketch.serialize((CountMinSketch)this.countMinSketch));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] countMinBytes = (byte[])in.readObject();
        this.countMinSketch = CountMinSketch.deserialize((byte[])countMinBytes);
    }

    protected static class CMHeavyHitterMergeException
    extends HeavyHitterMergeException {
        public CMHeavyHitterMergeException(String message) {
            super(message);
        }
    }
}

