/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.operatorstatistics;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.stream.cardinality.LinearCounting;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.flink.contrib.operatorstatistics.OperatorStatisticsConfig;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.CountMinHeavyHitter;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.HeavyHitter;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.HeavyHitterMergeException;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.LossyCounting;

public class OperatorStatistics
implements Serializable {
    OperatorStatisticsConfig config;
    transient Object min = null;
    transient Object max = null;
    long cardinality = 0L;
    transient ICardinality countDistinct;
    transient HeavyHitter heavyHitter;

    public OperatorStatistics(OperatorStatisticsConfig config) {
        this.config = config;
        if (config.collectCountDistinct) {
            if (config.countDistinctAlgorithm.equals((Object)OperatorStatisticsConfig.CountDistinctAlgorithm.LINEAR_COUNTING)) {
                this.countDistinct = new LinearCounting(config.getCountDbitmap());
            }
            if (config.countDistinctAlgorithm.equals((Object)OperatorStatisticsConfig.CountDistinctAlgorithm.HYPERLOGLOG)) {
                this.countDistinct = new HyperLogLog(config.getCountDlog2m());
            }
        }
        if (config.collectHeavyHitters) {
            if (config.heavyHitterAlgorithm.equals((Object)OperatorStatisticsConfig.HeavyHitterAlgorithm.LOSSY_COUNTING)) {
                this.heavyHitter = new LossyCounting(config.getHeavyHitterFraction(), config.getHeavyHitterError());
            }
            if (config.heavyHitterAlgorithm.equals((Object)OperatorStatisticsConfig.HeavyHitterAlgorithm.COUNT_MIN_SKETCH)) {
                this.heavyHitter = new CountMinHeavyHitter(config.getHeavyHitterFraction(), config.getHeavyHitterError(), config.getHeavyHitterConfidence(), config.getHeavyHitterSeed());
            }
        }
    }

    public void process(Object tupleObject) {
        if (tupleObject instanceof Comparable) {
            if (this.config.collectMin && (this.min == null || ((Comparable)tupleObject).compareTo(this.min) < 0)) {
                this.min = tupleObject;
            }
            if (this.config.collectMax && (this.max == null || ((Comparable)tupleObject).compareTo(this.max) > 0)) {
                this.max = tupleObject;
            }
        }
        if (this.config.collectCountDistinct) {
            this.countDistinct.offer(tupleObject);
        }
        if (this.config.collectHeavyHitters) {
            this.heavyHitter.addObject(tupleObject);
        }
        ++this.cardinality;
    }

    public void merge(OperatorStatistics other) throws RuntimeException {
        if (this.config.collectMin & other.min != null && (this.min == null || ((Comparable)other.min).compareTo(this.min) < 0)) {
            this.min = other.min;
        }
        if (this.config.collectMax && other.max != null && (this.max == null || ((Comparable)other.max).compareTo(this.max) > 0)) {
            this.max = other.max;
        }
        if (this.config.collectCountDistinct) {
            try {
                ICardinality mergedCountDistinct;
                this.countDistinct = mergedCountDistinct = this.countDistinct.merge(new ICardinality[]{this.countDistinct, other.countDistinct});
            }
            catch (CardinalityMergeException e) {
                throw new RuntimeException("Error merging count distinct structures", e);
            }
        }
        if (this.config.collectHeavyHitters) {
            try {
                this.heavyHitter.merge(other.heavyHitter);
            }
            catch (HeavyHitterMergeException e) {
                throw new RuntimeException("Error merging heavy hitter structures", e);
            }
        }
        this.cardinality += other.cardinality;
    }

    public Object getMin() {
        return this.min;
    }

    public Object getMax() {
        return this.max;
    }

    public long estimateCountDistinct() {
        return this.countDistinct.cardinality();
    }

    public Map<Object, Long> getHeavyHitters() {
        return this.heavyHitter.getHeavyHitters();
    }

    public String toString() {
        String out = "\ntotal cardinality: " + this.cardinality;
        if (this.config.collectMax) {
            out = out + "\nmax: " + this.max;
        }
        if (this.config.collectMin) {
            out = out + "\nmin: " + this.min;
        }
        if (this.config.collectCountDistinct) {
            out = this.config.countDistinctAlgorithm.equals((Object)OperatorStatisticsConfig.CountDistinctAlgorithm.HYPERLOGLOG) ? out + "\ncount distinct estimate(" + (Object)((Object)this.config.countDistinctAlgorithm) + "[" + this.config.getCountDlog2m() + "]): " + this.countDistinct.cardinality() : out + "\ncount distinct estimate(" + (Object)((Object)this.config.countDistinctAlgorithm) + "[" + this.config.getCountDbitmap() + "]): " + this.countDistinct.cardinality();
        }
        if (this.config.collectHeavyHitters) {
            if (this.config.countDistinctAlgorithm.equals((Object)OperatorStatisticsConfig.HeavyHitterAlgorithm.LOSSY_COUNTING)) {
                out = out + "\nheavy hitters (" + (Object)((Object)this.config.heavyHitterAlgorithm) + "[" + this.config.getHeavyHitterFraction() + ", " + this.config.getHeavyHitterError() + "]):";
                out = out + "\n" + this.heavyHitter.toString();
            } else {
                out = out + "\nheavy hitters (" + (Object)((Object)this.config.heavyHitterAlgorithm) + "[" + this.config.getHeavyHitterFraction() + ", " + this.config.getHeavyHitterError() + ", " + this.config.getHeavyHitterConfidence() + "]):";
                out = out + "\n" + this.heavyHitter.toString();
            }
        }
        return out;
    }

    public OperatorStatistics clone() {
        Object copy;
        OperatorStatistics clone = new OperatorStatistics(this.config);
        clone.min = this.min;
        clone.max = this.max;
        clone.cardinality = this.cardinality;
        try {
            if (this.config.collectCountDistinct) {
                if (this.countDistinct instanceof LinearCounting) {
                    copy = new LinearCounting(this.config.getCountDbitmap());
                } else if (this.countDistinct instanceof HyperLogLog) {
                    copy = new HyperLogLog(this.config.getCountDlog2m());
                } else {
                    throw new IllegalStateException("Unsupported count distinct counter.");
                }
                clone.countDistinct = copy.merge(new ICardinality[]{this.countDistinct});
            }
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException("Faild to clone OperatorStatistics!");
        }
        try {
            if (this.config.collectHeavyHitters) {
                if (this.heavyHitter instanceof LossyCounting) {
                    copy = new LossyCounting(this.config.getHeavyHitterFraction(), this.config.getHeavyHitterError());
                } else if (this.heavyHitter instanceof CountMinHeavyHitter) {
                    copy = new CountMinHeavyHitter(this.config.getHeavyHitterFraction(), this.config.getHeavyHitterError(), this.config.getHeavyHitterConfidence(), this.config.getHeavyHitterSeed());
                } else {
                    throw new IllegalStateException("Unsupported heavy hitter counter.");
                }
                copy.merge(this.heavyHitter);
                clone.heavyHitter = copy;
            }
        }
        catch (HeavyHitterMergeException e) {
            throw new RuntimeException("Failed to clone OperatorStatistics!");
        }
        return clone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.config.collectMin) {
            out.writeObject(this.min);
        }
        if (this.config.collectMax) {
            out.writeObject(this.max);
        }
        if (this.config.collectCountDistinct) {
            if (this.config.countDistinctAlgorithm.equals((Object)OperatorStatisticsConfig.CountDistinctAlgorithm.LINEAR_COUNTING)) {
                out.writeObject(this.countDistinct.getBytes());
            } else {
                out.writeObject(this.countDistinct);
            }
        }
        if (this.config.collectHeavyHitters) {
            out.writeObject(this.heavyHitter);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.config.collectMin) {
            this.min = in.readObject();
        }
        if (this.config.collectMax) {
            this.max = in.readObject();
        }
        if (this.config.collectCountDistinct) {
            this.countDistinct = this.config.countDistinctAlgorithm.equals((Object)OperatorStatisticsConfig.CountDistinctAlgorithm.LINEAR_COUNTING) ? new LinearCounting((byte[])in.readObject()) : (HyperLogLog)in.readObject();
        }
        if (this.config.collectHeavyHitters) {
            this.heavyHitter = this.config.heavyHitterAlgorithm.equals((Object)OperatorStatisticsConfig.HeavyHitterAlgorithm.LOSSY_COUNTING) ? (LossyCounting)in.readObject() : (CountMinHeavyHitter)in.readObject();
        }
    }
}

