/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.operatorstatistics.heavyhitters;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.HeavyHitter;
import org.apache.flink.contrib.operatorstatistics.heavyhitters.HeavyHitterMergeException;

public class LossyCounting
implements HeavyHitter,
Serializable {
    private double fraction;
    private double error;
    private long cardinality;
    private Map<Object, Counter> heavyHitters;
    private long bucket;

    public LossyCounting(double fraction, double error) {
        this.fraction = fraction;
        this.error = error;
        this.cardinality = 0L;
        this.heavyHitters = new HashMap<Object, Counter>();
        this.bucket = 0L;
    }

    @Override
    public void addObject(Object o) {
        ++this.cardinality;
        if (this.heavyHitters.containsKey(o)) {
            this.heavyHitters.get(o).updateLowerBound(1L);
        } else {
            this.heavyHitters.put(o, new Counter(1L, this.bucket));
        }
        if (this.cardinality % (long)Math.ceil(1.0 / this.error) == 0L) {
            ++this.bucket;
            this.updateHeavyHitters();
        }
    }

    public void updateHeavyHitters() {
        Iterator<Map.Entry<Object, Counter>> it = this.heavyHitters.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue().getUpperBound() >= this.bucket) continue;
            it.remove();
        }
    }

    @Override
    public void merge(HeavyHitter toMerge) throws HeavyHitterMergeException {
        try {
            LossyCounting lsToMerge = (LossyCounting)toMerge;
            if (this.fraction != lsToMerge.fraction) {
                throw new HeavyHitterMergeException("Both heavy hitter structures must be identical");
            }
            this.cardinality += lsToMerge.cardinality;
            this.bucket = (long)Math.floor((double)this.cardinality * this.error);
            for (Map.Entry<Object, Counter> entry : lsToMerge.heavyHitters.entrySet()) {
                Counter counter = this.heavyHitters.get(entry.getKey());
                if (counter == null) {
                    this.heavyHitters.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Counter mergingCounter = entry.getValue();
                this.heavyHitters.put(entry.getKey(), new Counter(mergingCounter.lowerBound + counter.lowerBound, mergingCounter.frequencyError + counter.frequencyError));
            }
            this.updateHeavyHitters();
        }
        catch (ClassCastException ex) {
            throw new HeavyHitterMergeException("Both heavy hitter structures must be identical");
        }
    }

    @Override
    public HashMap<Object, Long> getHeavyHitters() {
        HashMap<Object, Long> heavyHitterLowerBounds = new HashMap<Object, Long>();
        long minFrequency = (long)Math.ceil((double)this.cardinality * (this.fraction - this.error));
        for (Map.Entry<Object, Counter> entry : this.heavyHitters.entrySet()) {
            if (entry.getValue().lowerBound < minFrequency) continue;
            heavyHitterLowerBounds.put(entry.getKey(), entry.getValue().lowerBound);
        }
        return heavyHitterLowerBounds;
    }

    @Override
    public String toString() {
        String out = "";
        long minFrequency = (long)Math.ceil((double)this.cardinality * (this.fraction - this.error));
        for (Map.Entry<Object, Counter> entry : this.heavyHitters.entrySet()) {
            if (entry.getValue().lowerBound < minFrequency) continue;
            out = out + entry.getKey().toString() + " -> lower bound " + entry.getValue().lowerBound + "\n";
        }
        return out;
    }

    private class Counter
    implements Serializable {
        long lowerBound;
        long frequencyError;

        private Counter(long lowerBound, long frequencyError) {
            this.lowerBound = lowerBound;
            this.frequencyError = frequencyError;
        }

        private void updateLowerBound(long count) {
            this.lowerBound += count;
        }

        private long getUpperBound() {
            return this.lowerBound + this.frequencyError;
        }
    }
}

