/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.operatorstatistics;

import java.io.Serializable;

public class OperatorStatisticsConfig
implements Serializable {
    private int countDbitmap = 1000000;
    private int countDlog2m = 10;
    private int heavyHitterSeed = 121311332;
    private double heavyHitterConfidence = 0.99;
    private double heavyHitterFraction = 0.05;
    private double heavyHitterError = 5.0E-4;
    public boolean collectMin;
    public boolean collectMax;
    public boolean collectCountDistinct;
    public boolean collectHeavyHitters;
    public CountDistinctAlgorithm countDistinctAlgorithm;
    public HeavyHitterAlgorithm heavyHitterAlgorithm;

    public OperatorStatisticsConfig() {
        this.collectMin = true;
        this.collectMax = true;
        this.collectCountDistinct = true;
        this.collectHeavyHitters = true;
        this.countDistinctAlgorithm = CountDistinctAlgorithm.HYPERLOGLOG;
        this.heavyHitterAlgorithm = HeavyHitterAlgorithm.LOSSY_COUNTING;
    }

    public OperatorStatisticsConfig(boolean collect) {
        this.collectMin = collect;
        this.collectMax = collect;
        this.collectCountDistinct = collect;
        this.collectHeavyHitters = collect;
        this.countDistinctAlgorithm = CountDistinctAlgorithm.HYPERLOGLOG;
        this.heavyHitterAlgorithm = HeavyHitterAlgorithm.LOSSY_COUNTING;
    }

    public OperatorStatisticsConfig(CountDistinctAlgorithm countDistinct, HeavyHitterAlgorithm heavyHitter) {
        this.collectMin = true;
        this.collectMax = true;
        this.collectCountDistinct = true;
        this.collectHeavyHitters = true;
        this.countDistinctAlgorithm = countDistinct;
        this.heavyHitterAlgorithm = heavyHitter;
    }

    public void setCountDbitmap(int countDbitmap) {
        this.countDbitmap = countDbitmap;
    }

    public void setCountDlog2m(int countDlog2m) {
        this.countDlog2m = countDlog2m;
    }

    public void setHeavyHitterConfidence(double heavyHitterConfidence) {
        this.heavyHitterConfidence = heavyHitterConfidence;
    }

    public void setHeavyHitterSeed(int heavyHitterSeed) {
        this.heavyHitterSeed = heavyHitterSeed;
    }

    public void setHeavyHitterFraction(double heavyHitterFraction) {
        this.heavyHitterFraction = heavyHitterFraction;
    }

    public void setHeavyHitterError(double heavyHitterError) {
        this.heavyHitterError = heavyHitterError;
    }

    public void setCollectMin(boolean collectMin) {
        this.collectMin = collectMin;
    }

    public void setCollectMax(boolean collectMax) {
        this.collectMax = collectMax;
    }

    public void setCollectCountDistinct(boolean collectCountDistinct) {
        this.collectCountDistinct = collectCountDistinct;
    }

    public void setCollectHeavyHitters(boolean collectHeavyHitters) {
        this.collectHeavyHitters = collectHeavyHitters;
    }

    public void setCountDistinctAlgorithm(CountDistinctAlgorithm countDistinctAlgorithm) {
        this.countDistinctAlgorithm = countDistinctAlgorithm;
    }

    public void setHeavyHitterAlgorithm(HeavyHitterAlgorithm heavyHitterAlgorithm) {
        this.heavyHitterAlgorithm = heavyHitterAlgorithm;
    }

    public int getCountDbitmap() {
        return this.countDbitmap;
    }

    public int getCountDlog2m() {
        return this.countDlog2m;
    }

    public int getHeavyHitterSeed() {
        return this.heavyHitterSeed;
    }

    public double getHeavyHitterConfidence() {
        return this.heavyHitterConfidence;
    }

    public double getHeavyHitterFraction() {
        return this.heavyHitterFraction;
    }

    public double getHeavyHitterError() {
        return this.heavyHitterError;
    }

    public static enum HeavyHitterAlgorithm {
        LOSSY_COUNTING,
        COUNT_MIN_SKETCH;

    }

    public static enum CountDistinctAlgorithm {
        LINEAR_COUNTING,
        HYPERLOGLOG;

    }
}

