/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseMatrix;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.junit.Assert;
import org.junit.Test;

public class BLASTest {
    private static final double TOLERANCE = 1.0E-7;
    private static final DenseVector inputDenseVec = Vectors.dense((double[])new double[]{1.0, -2.0, 3.0, 4.0, -5.0});
    private static final DenseMatrix inputDenseMat = new DenseMatrix(2, 5, new double[]{1.0, -2.0, 3.0, 4.0, -5.0, 1.0, -2.0, 3.0, 4.0, -5.0});

    @Test
    public void testAsum() {
        Assert.assertEquals((double)15.0, (double)BLAS.asum((DenseVector)inputDenseVec), (double)1.0E-7);
    }

    @Test
    public void testAxpy() {
        DenseVector anotherDenseVec = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        BLAS.axpy((double)1.0, (Vector)inputDenseVec, (DenseVector)anotherDenseVec);
        double[] expectedResult = new double[]{2.0, 0.0, 6.0, 8.0, 0.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])anotherDenseVec.values, (double)1.0E-7);
        SparseVector sparseVec = Vectors.sparse((int)5, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 3.0, 5.0});
        BLAS.axpy((double)2.0, (Vector)sparseVec, (DenseVector)anotherDenseVec);
        expectedResult = new double[]{4.0, 0.0, 12.0, 8.0, 10.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])anotherDenseVec.values, (double)1.0E-7);
    }

    @Test
    public void testAxpyK() {
        DenseVector anotherDenseVec = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0});
        BLAS.axpy((double)1.0, (Vector)inputDenseVec, (DenseVector)anotherDenseVec, (int)3);
        double[] expectedResult = new double[]{2.0, 0.0, 6.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])anotherDenseVec.values, (double)1.0E-7);
        SparseVector sparseVec = Vectors.sparse((int)5, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 3.0, 5.0});
        anotherDenseVec = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0});
        BLAS.axpy((double)2.0, (Vector)sparseVec, (DenseVector)anotherDenseVec, (int)5);
        expectedResult = new double[]{3.0, 2.0, 9.0, 4.0, 15.0, 6.0, 7.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])anotherDenseVec.values, (double)1.0E-7);
    }

    @Test
    public void testDot() {
        DenseVector anotherDenseVec = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        SparseVector sparseVector1 = Vectors.sparse((int)5, (int[])new int[]{1, 2, 4}, (double[])new double[]{1.0, 1.0, 4.0});
        SparseVector sparseVector2 = Vectors.sparse((int)5, (int[])new int[]{1, 3, 4}, (double[])new double[]{1.0, 2.0, 1.0});
        Assert.assertEquals((double)-3.0, (double)BLAS.dot((Vector)inputDenseVec, (Vector)anotherDenseVec), (double)1.0E-7);
        Assert.assertEquals((double)-19.0, (double)BLAS.dot((Vector)inputDenseVec, (Vector)sparseVector1), (double)1.0E-7);
        Assert.assertEquals((double)1.0, (double)BLAS.dot((Vector)sparseVector2, (Vector)inputDenseVec), (double)1.0E-7);
        Assert.assertEquals((double)5.0, (double)BLAS.dot((Vector)sparseVector1, (Vector)sparseVector2), (double)1.0E-7);
    }

    @Test
    public void testNorm2() {
        Assert.assertEquals((double)Math.sqrt(55.0), (double)BLAS.norm2((Vector)inputDenseVec), (double)1.0E-7);
        SparseVector sparseVector = Vectors.sparse((int)5, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 3.0, 5.0});
        Assert.assertEquals((double)Math.sqrt(35.0), (double)BLAS.norm2((Vector)sparseVector), (double)1.0E-7);
    }

    @Test
    public void testNorm() {
        Assert.assertEquals((double)Math.sqrt(55.0), (double)BLAS.norm((Vector)inputDenseVec, (double)2.0), (double)1.0E-7);
        SparseVector sparseVector = Vectors.sparse((int)5, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 3.0, 5.0});
        Assert.assertEquals((double)5.0, (double)BLAS.norm((Vector)sparseVector, (double)Double.POSITIVE_INFINITY), (double)1.0E-7);
        Assert.assertEquals((double)5.348481241239363, (double)BLAS.norm((Vector)sparseVector, (double)3.0), (double)1.0E-7);
    }

    @Test
    public void testScal() {
        BLAS.scal((double)2.0, (Vector)inputDenseVec);
        double[] expectedDenseResult = new double[]{2.0, -4.0, 6.0, 8.0, -10.0};
        Assert.assertArrayEquals((double[])expectedDenseResult, (double[])BLASTest.inputDenseVec.values, (double)1.0E-7);
        SparseVector inputSparseVector = Vectors.sparse((int)5, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 3.0, 5.0});
        BLAS.scal((double)1.5, (Vector)inputSparseVector);
        double[] expectedSparseResult = new double[]{1.5, 4.5, 7.5};
        int[] expectedSparseIndices = new int[]{0, 2, 4};
        Assert.assertArrayEquals((double[])expectedSparseResult, (double[])inputSparseVector.values, (double)1.0E-7);
        Assert.assertArrayEquals((int[])expectedSparseIndices, (int[])inputSparseVector.indices);
    }

    @Test
    public void testGemv() {
        DenseVector anotherDenseVec = Vectors.dense((double[])new double[]{1.0, 2.0});
        BLAS.gemv((double)-2.0, (DenseMatrix)inputDenseMat, (boolean)false, (DenseVector)inputDenseVec, (double)0.0, (DenseVector)anotherDenseVec);
        double[] expectedResult = new double[]{96.0, -60.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])anotherDenseVec.values, (double)1.0E-7);
    }

    @Test
    public void testHDot() {
        SparseVector sparseVec1 = Vectors.sparse((int)5, (int[])new int[]{0, 2, 3}, (double[])new double[]{1.0, 3.0, 5.0});
        SparseVector sparseVec2 = Vectors.sparse((int)5, (int[])new int[]{0, 1, 4}, (double[])new double[]{1.0, 3.0, 5.0});
        BLAS.hDot((Vector)sparseVec1, (Vector)sparseVec2);
        Assert.assertEquals((long)5L, (long)sparseVec2.size());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 4}, (int[])sparseVec2.indices);
        Assert.assertArrayEquals((double[])new double[]{1.0, 0.0, 0.0}, (double[])sparseVec2.values, (double)1.0E-7);
        DenseVector denseVec1 = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        DenseVector denseVec2 = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        BLAS.hDot((Vector)denseVec1, (Vector)denseVec2);
        double[] expectedResult = new double[]{1.0, 4.0, 9.0, 16.0, 25.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])denseVec2.values, (double)1.0E-7);
        BLAS.hDot((Vector)sparseVec1, (Vector)denseVec1);
        expectedResult = new double[]{1.0, 0.0, 9.0, 20.0, 0.0};
        Assert.assertArrayEquals((double[])expectedResult, (double[])denseVec1.values, (double)1.0E-7);
        DenseVector denseVec3 = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        BLAS.hDot((Vector)denseVec3, (Vector)sparseVec1);
        Assert.assertEquals((long)5L, (long)sparseVec1.size());
        Assert.assertArrayEquals((int[])new int[]{0, 2, 3}, (int[])sparseVec1.indices);
        Assert.assertArrayEquals((double[])new double[]{1.0, 9.0, 20.0}, (double[])sparseVec1.values, (double)1.0E-7);
    }
}

