/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.servable.builder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.ml.servable.TestUtils;
import org.apache.flink.ml.servable.api.DataFrame;
import org.apache.flink.ml.servable.api.Row;
import org.apache.flink.ml.servable.api.TransformerServable;
import org.apache.flink.ml.servable.builder.ExampleServables;
import org.apache.flink.ml.servable.builder.PipelineModelServable;
import org.apache.flink.ml.servable.types.DataTypes;
import org.junit.Test;

public class PipelineModelServableTest {
    @Test
    public void testTransform() throws IOException {
        ExampleServables.SumModelServable servableA = new ExampleServables.SumModelServable().setModelData(new ByteArrayInputStream(ExampleServables.SumModelServable.serialize(10)));
        ExampleServables.SumModelServable servableB = new ExampleServables.SumModelServable().setModelData(new ByteArrayInputStream(ExampleServables.SumModelServable.serialize(20)));
        ExampleServables.SumModelServable servableC = new ExampleServables.SumModelServable().setModelData(new ByteArrayInputStream(ExampleServables.SumModelServable.serialize(30)));
        List<TransformerServable> servables = Arrays.asList(servableA, servableB, servableC);
        PipelineModelServable pipelineModelServable = new PipelineModelServable(servables);
        DataFrame input = new DataFrame(Collections.singletonList("input"), Collections.singletonList(DataTypes.INT), Arrays.asList(new Row(Collections.singletonList(1)), new Row(Collections.singletonList(2)), new Row(Collections.singletonList(3))));
        DataFrame output = pipelineModelServable.transform(input);
        DataFrame expectedOutput = new DataFrame(Collections.singletonList("input"), Collections.singletonList(DataTypes.INT), Arrays.asList(new Row(Collections.singletonList(61)), new Row(Collections.singletonList(62)), new Row(Collections.singletonList(63))));
        TestUtils.assertDataFrameEquals(expectedOutput, output);
    }
}

