/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.servable.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.servable.api.DataFrame;
import org.apache.flink.ml.servable.api.ModelServable;
import org.apache.flink.ml.servable.api.Row;
import org.apache.flink.ml.servable.types.DataTypes;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ServableReadWriteUtils;
import org.apache.flink.util.Preconditions;

public class ExampleServables {

    public static class SumModelServable
    implements ModelServable<SumModelServable> {
        private static final String COL_NAME = "input";
        private final Map<Param<?>, Object> paramMap = new HashMap();
        private int delta;

        public SumModelServable() {
            ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
        }

        public DataFrame transform(DataFrame input) {
            ArrayList<Row> outputRows = new ArrayList<Row>();
            for (Row row : input.collect()) {
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                int originValue = (Integer)row.get(0);
                outputRows.add(new Row(Collections.singletonList(originValue + this.delta)));
            }
            return new DataFrame(Collections.singletonList(COL_NAME), Collections.singletonList(DataTypes.INT), outputRows);
        }

        public Map<Param<?>, Object> getParamMap() {
            return this.paramMap;
        }

        public static SumModelServable load(String path) throws IOException {
            SumModelServable servable = (SumModelServable)ServableReadWriteUtils.loadServableParam((String)path, SumModelServable.class);
            try (InputStream inputStream = ServableReadWriteUtils.loadModelData((String)path);){
                DataInputViewStreamWrapper dataInputViewStreamWrapper = new DataInputViewStreamWrapper(inputStream);
                servable.delta = IntSerializer.INSTANCE.deserialize((DataInputView)dataInputViewStreamWrapper);
                SumModelServable sumModelServable = servable;
                return sumModelServable;
            }
        }

        public SumModelServable setModelData(InputStream ... modelDataInputs) throws IOException {
            Preconditions.checkArgument((modelDataInputs.length == 1 ? 1 : 0) != 0);
            DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper(modelDataInputs[0]);
            this.delta = IntSerializer.INSTANCE.deserialize((DataInputView)inputViewStreamWrapper);
            return this;
        }

        public static byte[] serialize(Object modelData) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper((OutputStream)outputStream);
            IntSerializer.INSTANCE.serialize((Integer)modelData, (DataOutputView)outputViewStreamWrapper);
            return outputStream.toByteArray();
        }
    }
}

