/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.ml.linalg.Vectors;
import org.junit.Assert;
import org.junit.Test;

public class VectorWithNormTest {
    @Test
    public void testL2Norm() {
        DenseVector denseVector = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0});
        VectorWithNorm denseVectorWithNorm = new VectorWithNorm((Vector)denseVector);
        Assert.assertEquals((Object)denseVector, (Object)denseVectorWithNorm.vector);
        Assert.assertEquals((double)Math.sqrt(14.0), (double)denseVectorWithNorm.l2Norm, (double)1.0E-7);
        SparseVector sparseVector = Vectors.sparse((int)5, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 2.0, 3.0});
        VectorWithNorm sparseVectorWithNorm = new VectorWithNorm((Vector)sparseVector);
        Assert.assertEquals((Object)sparseVector, (Object)sparseVectorWithNorm.vector);
        Assert.assertEquals((double)Math.sqrt(14.0), (double)sparseVectorWithNorm.l2Norm, (double)1.0E-7);
    }
}

