/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.SparseVectorSerializer;
import org.junit.Assert;
import org.junit.Test;

public class SparseVectorTest {
    private static final double TOLERANCE = 1.0E-7;

    @Test
    public void testConstructor() {
        int n = 4;
        int[] indices = new int[]{0, 2, 3};
        double[] values = new double[]{0.1, 0.3, 0.4};
        SparseVector vector = Vectors.sparse((int)n, (int[])indices, (double[])values);
        Assert.assertEquals((long)n, (long)vector.n);
        Assert.assertArrayEquals((int[])indices, (int[])vector.indices);
        Assert.assertArrayEquals((double[])values, (double[])vector.values, (double)1.0E-5);
        Assert.assertEquals((Object)"(4, [0, 2, 3], [0.1, 0.3, 0.4])", (Object)vector.toString());
    }

    @Test
    public void testDuplicateIndex() {
        int n = 4;
        int[] indices = new int[]{0, 2, 2};
        double[] values = new double[]{0.1, 0.3, 0.4};
        try {
            Vectors.sparse((int)n, (int[])indices, (double[])values);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"Indices duplicated.", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllZeroVector() {
        int n = 4;
        SparseVector vector = Vectors.sparse((int)n, (int[])new int[0], (double[])new double[0]);
        Assert.assertArrayEquals((double[])vector.toArray(), (double[])new double[n], (double)1.0E-5);
    }

    @Test
    public void testUnsortedIndex() {
        SparseVector vector = Vectors.sparse((int)4, (int[])new int[]{2}, (double[])new double[]{0.3});
        Assert.assertEquals((long)4L, (long)vector.n);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])vector.indices);
        Assert.assertArrayEquals((double[])new double[]{0.3}, (double[])vector.values, (double)1.0E-5);
        vector = Vectors.sparse((int)4, (int[])new int[]{1, 2}, (double[])new double[]{0.2, 0.3});
        Assert.assertEquals((long)4L, (long)vector.n);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])vector.indices);
        Assert.assertArrayEquals((double[])new double[]{0.2, 0.3}, (double[])vector.values, (double)1.0E-5);
        vector = Vectors.sparse((int)4, (int[])new int[]{2, 1}, (double[])new double[]{0.3, 0.2});
        Assert.assertEquals((long)4L, (long)vector.n);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])vector.indices);
        Assert.assertArrayEquals((double[])new double[]{0.2, 0.3}, (double[])vector.values, (double)1.0E-5);
        vector = Vectors.sparse((int)4, (int[])new int[]{3, 2, 0}, (double[])new double[]{0.4, 0.3, 0.1});
        Assert.assertEquals((long)4L, (long)vector.n);
        Assert.assertArrayEquals((int[])new int[]{0, 2, 3}, (int[])vector.indices);
        Assert.assertArrayEquals((double[])new double[]{0.1, 0.3, 0.4}, (double[])vector.values, (double)1.0E-5);
        vector = Vectors.sparse((int)4, (int[])new int[]{2, 0, 3}, (double[])new double[]{0.3, 0.1, 0.4});
        Assert.assertEquals((long)4L, (long)vector.n);
        Assert.assertArrayEquals((int[])new int[]{0, 2, 3}, (int[])vector.indices);
        Assert.assertArrayEquals((double[])new double[]{0.1, 0.3, 0.4}, (double[])vector.values, (double)1.0E-5);
        vector = Vectors.sparse((int)7, (int[])new int[]{6, 5, 4, 3, 2, 1, 0}, (double[])new double[]{0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1});
        Assert.assertEquals((long)7L, (long)vector.n);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])vector.indices);
        Assert.assertArrayEquals((double[])new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7}, (double[])vector.values, (double)1.0E-5);
    }

    @Test
    public void testSerializer() throws IOException {
        int n = 4;
        int[] indices = new int[]{0, 2, 3};
        double[] values = new double[]{0.1, 0.3, 0.4};
        SparseVector vector = Vectors.sparse((int)n, (int[])indices, (double[])values);
        SparseVectorSerializer serializer = SparseVectorSerializer.INSTANCE;
        ByteArrayOutputStream bOutput = new ByteArrayOutputStream(1024);
        DataOutputViewStreamWrapper output = new DataOutputViewStreamWrapper((OutputStream)bOutput);
        serializer.serialize(vector, (DataOutputView)output);
        byte[] b = bOutput.toByteArray();
        ByteArrayInputStream bInput = new ByteArrayInputStream(b);
        DataInputViewStreamWrapper input = new DataInputViewStreamWrapper((InputStream)bInput);
        SparseVector vector2 = serializer.deserialize((DataInputView)input);
        Assert.assertEquals((long)vector.n, (long)vector2.n);
        Assert.assertArrayEquals((int[])vector.indices, (int[])vector2.indices);
        Assert.assertArrayEquals((double[])vector.values, (double[])vector2.values, (double)1.0E-5);
    }

    @Test
    public void testClone() {
        SparseVector sparseVec = Vectors.sparse((int)3, (int[])new int[]{0, 2}, (double[])new double[]{1.0, 3.0});
        SparseVector clonedSparseVec = sparseVec.clone();
        Assert.assertEquals((long)3L, (long)clonedSparseVec.size());
        Assert.assertArrayEquals((int[])clonedSparseVec.indices, (int[])new int[]{0, 2});
        Assert.assertArrayEquals((double[])clonedSparseVec.values, (double[])new double[]{1.0, 3.0}, (double)1.0E-7);
        clonedSparseVec.values[0] = -1.0;
        Assert.assertEquals((long)sparseVec.size(), (long)clonedSparseVec.size());
        Assert.assertArrayEquals((int[])sparseVec.indices, (int[])new int[]{0, 2});
        Assert.assertArrayEquals((double[])sparseVec.values, (double[])new double[]{1.0, 3.0}, (double)1.0E-7);
        Assert.assertArrayEquals((int[])clonedSparseVec.indices, (int[])new int[]{0, 2});
        Assert.assertArrayEquals((double[])clonedSparseVec.values, (double[])new double[]{-1.0, 3.0}, (double)1.0E-7);
    }

    @Test
    public void testGetAndSet() {
        SparseVector sparseVec = Vectors.sparse((int)4, (int[])new int[]{2}, (double[])new double[]{0.3});
        Assert.assertEquals((double)0.0, (double)sparseVec.get(0), (double)1.0E-7);
        Assert.assertEquals((double)0.3, (double)sparseVec.get(2), (double)1.0E-7);
        sparseVec.set(2, 0.5);
        Assert.assertEquals((double)0.5, (double)sparseVec.get(2), (double)1.0E-7);
        sparseVec.set(0, 0.1);
        Assert.assertEquals((double)0.1, (double)sparseVec.get(0), (double)1.0E-7);
    }
}

