/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.junit.Assert;
import org.junit.Test;

public class DenseVectorTest {
    private static final double TOLERANCE = 1.0E-7;

    @Test
    public void testClone() {
        DenseVector denseVec = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0});
        DenseVector clonedDenseVec = denseVec.clone();
        Assert.assertArrayEquals((double[])clonedDenseVec.values, (double[])new double[]{1.0, 2.0, 3.0}, (double)1.0E-7);
        clonedDenseVec.values[0] = -1.0;
        Assert.assertArrayEquals((double[])denseVec.values, (double[])new double[]{1.0, 2.0, 3.0}, (double)1.0E-7);
        Assert.assertArrayEquals((double[])clonedDenseVec.values, (double[])new double[]{-1.0, 2.0, 3.0}, (double)1.0E-7);
    }

    @Test
    public void testGetAndSet() {
        DenseVector denseVec = Vectors.dense((double[])new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((double)1.0, (double)denseVec.get(0), (double)1.0E-7);
        denseVec.set(0, 2.0);
        Assert.assertEquals((double)2.0, (double)denseVec.get(0), (double)1.0E-7);
    }
}

