/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.distance;

import org.apache.flink.ml.common.distance.CosineDistanceMeasure;
import org.apache.flink.ml.common.distance.EuclideanDistanceMeasure;
import org.apache.flink.ml.common.distance.ManhattanDistanceMeasure;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.ml.linalg.Vectors;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class DistanceMeasureTest {
    private static final VectorWithNorm VECTOR_WITH_NORM_A = new VectorWithNorm((Vector)Vectors.sparse((int)3, (int[])new int[]{1, 2}, (double[])new double[]{1.0, 2.0}));
    private static final VectorWithNorm VECTOR_WITH_NORM_B = new VectorWithNorm((Vector)Vectors.dense((double[])new double[]{1.0, 2.0, 3.0}));
    private static final VectorWithNorm[] CENTROIDS = new VectorWithNorm[]{new VectorWithNorm((Vector)Vectors.dense((double[])new double[]{0.0, 1.0, 2.0})), new VectorWithNorm((Vector)Vectors.dense((double[])new double[]{1.0, 2.0, 3.0})), new VectorWithNorm((Vector)Vectors.dense((double[])new double[]{2.0, 3.0, 4.0}))};
    private static final double TOLERANCE = 1.0E-7;

    @Test
    public void testEuclidean() {
        EuclideanDistanceMeasure distanceMeasure = EuclideanDistanceMeasure.getInstance();
        Assertions.assertEquals((double)Math.sqrt(3.0), (double)distanceMeasure.distance(VECTOR_WITH_NORM_A, VECTOR_WITH_NORM_B), (double)1.0E-7);
        Assertions.assertEquals((int)0, (int)distanceMeasure.findClosest(CENTROIDS, VECTOR_WITH_NORM_A));
        Assertions.assertEquals((int)1, (int)distanceMeasure.findClosest(CENTROIDS, VECTOR_WITH_NORM_B));
    }

    @Test
    public void testEuclideanOfIdenticalVectors() {
        VectorWithNorm vector = new VectorWithNorm((Vector)Vectors.dense((double[])new double[]{3.0, 3.0}));
        EuclideanDistanceMeasure distanceMeasure = EuclideanDistanceMeasure.getInstance();
        Assertions.assertEquals((double)0.0, (double)distanceMeasure.distance(vector, vector));
    }

    @Test
    public void testManhattan() {
        ManhattanDistanceMeasure distanceMeasure = ManhattanDistanceMeasure.getInstance();
        Assertions.assertEquals((double)3.0, (double)distanceMeasure.distance(VECTOR_WITH_NORM_A, VECTOR_WITH_NORM_B), (double)1.0E-7);
        Assertions.assertEquals((int)0, (int)distanceMeasure.findClosest(CENTROIDS, VECTOR_WITH_NORM_A));
        Assertions.assertEquals((int)1, (int)distanceMeasure.findClosest(CENTROIDS, VECTOR_WITH_NORM_B));
    }

    @Test
    public void testCosine() {
        CosineDistanceMeasure distanceMeasure = CosineDistanceMeasure.getInstance();
        Assertions.assertEquals((double)0.04381711, (double)distanceMeasure.distance(VECTOR_WITH_NORM_A, VECTOR_WITH_NORM_B), (double)1.0E-7);
        Assertions.assertEquals((int)0, (int)distanceMeasure.findClosest(CENTROIDS, VECTOR_WITH_NORM_A));
        Assertions.assertEquals((int)1, (int)distanceMeasure.findClosest(CENTROIDS, VECTOR_WITH_NORM_B));
    }
}

