/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.regression;

import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.regression.linearregression.LinearRegression;
import org.apache.flink.ml.regression.linearregression.LinearRegressionModel;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class LinearRegressionExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.0, 1.0}), 4.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{3.0, 2.0}), 7.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{4.0, 3.0}), 10.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.0, 4.0}), 10.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.0, 2.0}), 6.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{4.0, 3.0}), 10.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.0, 2.0}), 5.0, 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{5.0, 3.0}), 11.0, 1.0})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("features", new String[]{"label", "weight"});
        LinearRegression lr = (LinearRegression)new LinearRegression().setWeightCol("weight");
        LinearRegressionModel lrModel = lr.fit(new Table[]{inputTable});
        Table outputTable = lrModel.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector features = (DenseVector)row.getField(lr.getFeaturesCol());
            double expectedResult = (Double)row.getField(lr.getLabelCol());
            double predictionResult = (Double)row.getField(lr.getPredictionCol());
            System.out.printf("Features: %s \tExpected Result: %s \tPrediction Result: %s\n", features, expectedResult, predictionResult);
        }
    }
}

