/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.ml.feature.lsh.MinHashLSH;
import org.apache.flink.ml.feature.lsh.MinHashLSHModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;

public class MinHashLSHExample {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        Table dataA = tEnv.fromDataStream((DataStream)env.fromCollection(Arrays.asList(Row.of((Object[])new Object[]{0, Vectors.sparse((int)6, (int[])new int[]{0, 1, 2}, (double[])new double[]{1.0, 1.0, 1.0})}), Row.of((Object[])new Object[]{1, Vectors.sparse((int)6, (int[])new int[]{2, 3, 4}, (double[])new double[]{1.0, 1.0, 1.0})}), Row.of((Object[])new Object[]{2, Vectors.sparse((int)6, (int[])new int[]{0, 2, 4}, (double[])new double[]{1.0, 1.0, 1.0})})), Types.ROW_NAMED((String[])new String[]{"id", "vec"}, (TypeInformation[])new TypeInformation[]{Types.INT, TypeInformation.of(SparseVector.class)})));
        Table dataB = tEnv.fromDataStream((DataStream)env.fromCollection(Arrays.asList(Row.of((Object[])new Object[]{3, Vectors.sparse((int)6, (int[])new int[]{1, 3, 5}, (double[])new double[]{1.0, 1.0, 1.0})}), Row.of((Object[])new Object[]{4, Vectors.sparse((int)6, (int[])new int[]{2, 3, 5}, (double[])new double[]{1.0, 1.0, 1.0})}), Row.of((Object[])new Object[]{5, Vectors.sparse((int)6, (int[])new int[]{1, 2, 4}, (double[])new double[]{1.0, 1.0, 1.0})})), Types.ROW_NAMED((String[])new String[]{"id", "vec"}, (TypeInformation[])new TypeInformation[]{Types.INT, TypeInformation.of(SparseVector.class)})));
        MinHashLSH lsh = (MinHashLSH)((MinHashLSH)((MinHashLSH)((MinHashLSH)new MinHashLSH().setInputCol("vec")).setOutputCol("hashes")).setSeed(2022L)).setNumHashTables(Integer.valueOf(5));
        MinHashLSHModel model = (MinHashLSHModel)lsh.fit(new Table[]{dataA});
        Table output = model.transform(new Table[]{dataA})[0];
        List fieldNames = output.getResolvedSchema().getColumnNames();
        for (Row result : IteratorUtils.toList((Iterator)tEnv.toDataStream(output).executeAndCollect())) {
            Vector inputValue = (Vector)result.getFieldAs(fieldNames.indexOf(lsh.getInputCol()));
            Object[] outputValue = (DenseVector[])result.getFieldAs(fieldNames.indexOf(lsh.getOutputCol()));
            System.out.printf("Vector: %s \tHash values: %s\n", inputValue, Arrays.toString(outputValue));
        }
        SparseVector key = Vectors.sparse((int)6, (int[])new int[]{1, 3}, (double[])new double[]{1.0, 1.0});
        output = model.approxNearestNeighbors(dataA, (Vector)key, 2).select(new Expression[]{Expressions.$((String)"id"), Expressions.$((String)"distCol")});
        for (Row result : IteratorUtils.toList((Iterator)tEnv.toDataStream(output).executeAndCollect())) {
            int idValue = (Integer)result.getFieldAs(fieldNames.indexOf("id"));
            double distValue = (Double)result.getFieldAs(result.getArity() - 1);
            System.out.printf("ID: %d \tDistance: %f\n", idValue, distValue);
        }
        output = model.approxSimilarityJoin(dataA, dataB, 0.6, "id");
        for (Row result : IteratorUtils.toList((Iterator)tEnv.toDataStream(output).executeAndCollect())) {
            int idAValue = (Integer)result.getFieldAs(0);
            int idBValue = (Integer)result.getFieldAs(1);
            double distValue = (Double)result.getFieldAs(2);
            System.out.printf("ID from left: %d \tID from right: %d \t Distance: %f\n", idAValue, idBValue, distValue);
        }
    }
}

