/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.clustering;

import org.apache.flink.ml.clustering.agglomerativeclustering.AgglomerativeClustering;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class AgglomerativeClusteringExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new DenseVector[]{Vectors.dense((double[])new double[]{1.0, 1.0}), Vectors.dense((double[])new double[]{1.0, 4.0}), Vectors.dense((double[])new double[]{1.0, 0.0}), Vectors.dense((double[])new double[]{4.0, 1.5}), Vectors.dense((double[])new double[]{4.0, 4.0}), Vectors.dense((double[])new double[]{4.0, 0.0})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("features", new String[0]);
        AgglomerativeClustering agglomerativeClustering = (AgglomerativeClustering)((AgglomerativeClustering)((AgglomerativeClustering)((AgglomerativeClustering)new AgglomerativeClustering().setLinkage("ward")).setDistanceMeasure("euclidean")).setPredictionCol("prediction")).setComputeFullTree(Boolean.valueOf(true));
        Table[] outputs = agglomerativeClustering.transform(new Table[]{inputTable});
        CloseableIterator it = outputs[0].execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector features = (DenseVector)row.getField(agglomerativeClustering.getFeaturesCol());
            int clusterId = (Integer)row.getField(agglomerativeClustering.getPredictionCol());
            System.out.printf("Features: %s \tCluster ID: %s\n", features, clusterId);
        }
    }
}

