/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.util.param;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.ml.api.misc.param.ParamInfo;
import org.apache.flink.ml.api.misc.param.WithParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractParamInfosUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractParamInfosUtil.class);

    public static List<ParamInfo> extractParamInfos(WithParams s) {
        return ExtractParamInfosUtil.extractParamInfos(s, s.getClass());
    }

    private static List<ParamInfo> extractParamInfos(WithParams s, Class clz) {
        ArrayList<ParamInfo> result = new ArrayList<ParamInfo>();
        if (clz == null) {
            return result;
        }
        Field[] fields = clz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!ParamInfo.class.isAssignableFrom(field.getType())) continue;
            try {
                result.add((ParamInfo)field.get(s));
            }
            catch (IllegalAccessException e) {
                LOG.warn("Failed to extract param info {}, ignore it", (Object)field.getName(), (Object)e);
            }
        }
        result.addAll(ExtractParamInfosUtil.extractParamInfos(s, clz.getSuperclass()));
        for (AnnotatedElement annotatedElement : clz.getInterfaces()) {
            result.addAll(ExtractParamInfosUtil.extractParamInfos(s, (Class)annotatedElement));
        }
        return result;
    }
}

