/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.api.misc.param;

import org.apache.flink.ml.api.misc.param.ParamInfo;
import org.apache.flink.ml.api.misc.param.ParamValidator;

public class ParamInfoFactory {
    public static <V> ParamInfoBuilder<V> createParamInfo(String name, Class<V> valueClass) {
        return new ParamInfoBuilder<V>(name, valueClass);
    }

    public static class ParamInfoBuilder<V> {
        private String name;
        private String[] alias = new String[0];
        private String description;
        private boolean isOptional = true;
        private boolean hasDefaultValue = false;
        private V defaultValue;
        private ParamValidator<V> validator;
        private Class<V> valueClass;

        ParamInfoBuilder(String name, Class<V> valueClass) {
            this.name = name;
            this.valueClass = valueClass;
        }

        public ParamInfoBuilder<V> setAlias(String[] alias) {
            this.alias = alias;
            return this;
        }

        public ParamInfoBuilder<V> setDescription(String description) {
            this.description = description;
            return this;
        }

        public ParamInfoBuilder<V> setOptional() {
            this.isOptional = true;
            return this;
        }

        public ParamInfoBuilder<V> setRequired() {
            this.isOptional = false;
            return this;
        }

        public ParamInfoBuilder<V> setHasDefaultValue(V defaultValue) {
            this.hasDefaultValue = true;
            this.defaultValue = defaultValue;
            return this;
        }

        public ParamInfoBuilder<V> setValidator(ParamValidator<V> validator) {
            this.validator = validator;
            return this;
        }

        public ParamInfo<V> build() {
            return new ParamInfo<V>(this.name, this.alias, this.description, this.isOptional, this.hasDefaultValue, this.defaultValue, this.validator, this.valueClass);
        }
    }
}

