/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.api.misc.param;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.api.misc.param.ParamInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

@PublicEvolving
public class Params
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> params = new HashMap<String, String>();
    private transient ObjectMapper mapper;

    public int size() {
        return this.params.size();
    }

    public void clear() {
        this.params.clear();
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public <V> V get(ParamInfo<V> info) {
        String value = null;
        String usedParamName = null;
        for (String nameOrAlias : this.getParamNameAndAlias(info)) {
            if (!this.params.containsKey(nameOrAlias)) continue;
            if (usedParamName != null) {
                throw new IllegalArgumentException(String.format("Duplicate parameters of %s and %s", usedParamName, nameOrAlias));
            }
            usedParamName = nameOrAlias;
            value = this.params.get(nameOrAlias);
        }
        if (usedParamName != null) {
            return this.valueFromJson(value, info.getValueClass());
        }
        if (!info.isOptional()) {
            throw new IllegalArgumentException("Missing non-optional parameter " + info.getName());
        }
        if (!info.hasDefaultValue()) {
            throw new IllegalArgumentException("Cannot find default value for optional parameter " + info.getName());
        }
        return info.getDefaultValue();
    }

    public <V> Params set(ParamInfo<V> info, V value) {
        if (info.getValidator() != null && !info.getValidator().validate(value)) {
            throw new RuntimeException("Setting " + info.getName() + " as a invalid value:" + value);
        }
        this.params.put(info.getName(), this.valueToJson(value));
        return this;
    }

    public <V> void remove(ParamInfo<V> info) {
        this.params.remove(info.getName());
        for (String a : info.getAlias()) {
            this.params.remove(a);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <V> boolean contains(ParamInfo<V> info) {
        if (this.params.containsKey(info.getName())) return true;
        if (!Arrays.stream(info.getAlias()).anyMatch(this.params::containsKey)) return false;
        return true;
    }

    public String toJson() {
        this.assertMapperInited();
        try {
            return this.mapper.writeValueAsString(this.params);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize params to json", e);
        }
    }

    public void loadJson(String json) {
        Map params;
        this.assertMapperInited();
        try {
            params = (Map)this.mapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize json:" + json, e);
        }
        this.params.putAll(params);
    }

    public static Params fromJson(String json) {
        Params params = new Params();
        params.loadJson(json);
        return params;
    }

    public Params merge(Params otherParams) {
        if (otherParams != null) {
            this.params.putAll(otherParams.params);
        }
        return this;
    }

    public Params clone() {
        Params newParams = new Params();
        newParams.params.putAll(this.params);
        return newParams;
    }

    private void assertMapperInited() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
    }

    private String valueToJson(Object value) {
        this.assertMapperInited();
        try {
            if (value == null) {
                return null;
            }
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize to json:" + value, e);
        }
    }

    private <T> T valueFromJson(String json, Class<T> clazz) {
        this.assertMapperInited();
        try {
            if (json == null) {
                return null;
            }
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize json:" + json, e);
        }
    }

    private <V> List<String> getParamNameAndAlias(ParamInfo<V> info) {
        ArrayList<String> paramNames = new ArrayList<String>(info.getAlias().length + 1);
        paramNames.add(info.getName());
        paramNames.addAll(Arrays.asList(info.getAlias()));
        return paramNames;
    }
}

