/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.statsd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.AbstractReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StatsDReporter
extends AbstractReporter
implements Scheduled {
    private static final Logger LOG = LoggerFactory.getLogger(StatsDReporter.class);
    public static final String ARG_HOST = "host";
    public static final String ARG_PORT = "port";
    private boolean closed = false;
    private DatagramSocket socket;
    private InetSocketAddress address;

    public void open(MetricConfig config) {
        String host = config.getString(ARG_HOST, null);
        int port = config.getInteger(ARG_PORT, -1);
        if (host == null || host.length() == 0 || port < 1) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        this.address = new InetSocketAddress(host, port);
        LOG.info("Starting StatsDReporter to send metric reports to " + this.address);
        try {
            this.socket = new DatagramSocket(0);
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not create datagram socket. ", e);
        }
    }

    public void close() {
        this.closed = true;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void report() {
        try {
            for (Map.Entry entry : this.gauges.entrySet()) {
                if (this.closed) {
                    return;
                }
                this.reportGauge((String)entry.getValue(), (Gauge)entry.getKey());
            }
            for (Map.Entry entry : this.counters.entrySet()) {
                if (this.closed) {
                    return;
                }
                this.reportCounter((String)entry.getValue(), (Counter)entry.getKey());
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                this.reportHistogram((String)entry.getValue(), (Histogram)entry.getKey());
            }
        }
        catch (ConcurrentModificationException | NoSuchElementException runtimeException) {
            // empty catch block
        }
    }

    private void reportCounter(String name, Counter counter) {
        this.send(name, String.valueOf(counter.getCount()));
    }

    private void reportGauge(String name, Gauge<?> gauge) {
        Object value = gauge.getValue();
        if (value != null) {
            this.send(name, value.toString());
        }
    }

    private void reportHistogram(String name, Histogram histogram) {
        HistogramStatistics statistics;
        if (histogram != null && (statistics = histogram.getStatistics()) != null) {
            this.send(this.prefix(name, "count"), String.valueOf(histogram.getCount()));
            this.send(this.prefix(name, "max"), String.valueOf(statistics.getMax()));
            this.send(this.prefix(name, "min"), String.valueOf(statistics.getMin()));
            this.send(this.prefix(name, "mean"), String.valueOf(statistics.getMean()));
            this.send(this.prefix(name, "stddev"), String.valueOf(statistics.getStdDev()));
            this.send(this.prefix(name, "p50"), String.valueOf(statistics.getQuantile(0.5)));
            this.send(this.prefix(name, "p75"), String.valueOf(statistics.getQuantile(0.75)));
            this.send(this.prefix(name, "p95"), String.valueOf(statistics.getQuantile(0.95)));
            this.send(this.prefix(name, "p98"), String.valueOf(statistics.getQuantile(0.98)));
            this.send(this.prefix(name, "p99"), String.valueOf(statistics.getQuantile(0.99)));
            this.send(this.prefix(name, "p999"), String.valueOf(statistics.getQuantile(0.999)));
        }
    }

    private String prefix(String ... names) {
        if (names.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(names[0]);
            for (int i = 1; i < names.length; ++i) {
                stringBuilder.append('.').append(names[i]);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private void send(String name, String value) {
        try {
            String formatted = String.format("%s:%s|g", name, value);
            byte[] data = formatted.getBytes();
            this.socket.send(new DatagramPacket(data, data.length, this.address));
        }
        catch (IOException e) {
            LOG.error("unable to send packet to statsd at '{}:{}'", (Object)this.address.getHostName(), (Object)this.address.getPort());
        }
    }

    public String filterCharacters(String input) {
        char[] chars = null;
        int strLen = input.length();
        int pos = 0;
        block3: for (int i = 0; i < strLen; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ':': {
                    if (chars == null) {
                        chars = input.toCharArray();
                    }
                    chars[pos++] = 45;
                    continue block3;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? input : new String(chars, 0, pos);
    }
}

