/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.flink.shaded.io.prometheus.client.exporter.HTTPServer;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class PrometheusReporter
extends AbstractPrometheusReporter {
    static final String ARG_PORT = "port";
    private static final String DEFAULT_PORT = "9249";
    private HTTPServer httpServer;
    private int port;

    @VisibleForTesting
    int getPort() {
        Preconditions.checkState((this.httpServer != null ? 1 : 0) != 0, (Object)"Server has not been initialized.");
        return this.port;
    }

    @Override
    public void open(MetricConfig config) {
        super.open(config);
        String portsConfig = config.getString(ARG_PORT, DEFAULT_PORT);
        Iterator ports = NetUtils.getPortRangeFromString((String)portsConfig);
        while (ports.hasNext()) {
            int port = (Integer)ports.next();
            try {
                this.httpServer = new HTTPServer(port);
                this.port = port;
                this.log.info("Started PrometheusReporter HTTP server on port {}.", (Object)port);
                break;
            }
            catch (IOException ioe) {
                this.log.debug("Could not start PrometheusReporter HTTP server on port {}.", (Object)port, (Object)ioe);
            }
        }
        if (this.httpServer == null) {
            throw new RuntimeException("Could not start PrometheusReporter HTTP server on any configured port. Ports: " + portsConfig);
        }
    }

    @Override
    public void close() {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        super.close();
    }
}

