/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.flink.metrics.reporter.InstantiateViaFactory;
import org.apache.flink.util.Preconditions;

@InstantiateViaFactory(factoryClassName="org.apache.flink.metrics.prometheus.PrometheusReporterFactory")
@PublicEvolving
public class PrometheusReporter
extends AbstractPrometheusReporter {
    private HTTPServer httpServer;
    private int port;

    @VisibleForTesting
    int getPort() {
        Preconditions.checkState((this.httpServer != null ? 1 : 0) != 0, (Object)"Server has not been initialized.");
        return this.port;
    }

    PrometheusReporter(Iterator<Integer> ports) {
        while (ports.hasNext()) {
            this.port = ports.next();
            try {
                this.httpServer = new HTTPServer(this.port);
                this.log.info("Started PrometheusReporter HTTP server on port {}.", (Object)this.port);
                break;
            }
            catch (IOException ioe) {
                this.log.debug("Could not start PrometheusReporter HTTP server on port {}.", (Object)this.port, (Object)ioe);
            }
        }
        if (this.httpServer == null) {
            throw new RuntimeException("Could not start PrometheusReporter HTTP server on any configured port. Ports: " + ports);
        }
    }

    @Override
    public void close() {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        super.close();
    }
}

