/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporterOptions;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.shaded.io.prometheus.client.CollectorRegistry;
import org.apache.flink.shaded.io.prometheus.client.exporter.PushGateway;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public class PrometheusPushGatewayReporter
extends AbstractPrometheusReporter
implements Scheduled {
    private PushGateway pushGateway;
    private String jobName;
    private boolean deleteOnShutdown;
    private Map<String, String> groupingKey;

    @Override
    public void open(MetricConfig config) {
        super.open(config);
        String host = config.getString(PrometheusPushGatewayReporterOptions.HOST.key(), (String)PrometheusPushGatewayReporterOptions.HOST.defaultValue());
        int port = config.getInteger(PrometheusPushGatewayReporterOptions.PORT.key(), ((Integer)PrometheusPushGatewayReporterOptions.PORT.defaultValue()).intValue());
        String configuredJobName = config.getString(PrometheusPushGatewayReporterOptions.JOB_NAME.key(), (String)PrometheusPushGatewayReporterOptions.JOB_NAME.defaultValue());
        boolean randomSuffix = config.getBoolean(PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.key(), ((Boolean)PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.defaultValue()).booleanValue());
        this.deleteOnShutdown = config.getBoolean(PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.key(), ((Boolean)PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.defaultValue()).booleanValue());
        this.groupingKey = this.parseGroupingKey(config.getString(PrometheusPushGatewayReporterOptions.GROUPING_KEY.key(), (String)PrometheusPushGatewayReporterOptions.GROUPING_KEY.defaultValue()));
        if (host == null || host.isEmpty() || port < 1) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        this.jobName = randomSuffix ? configuredJobName + new AbstractID() : configuredJobName;
        this.pushGateway = new PushGateway(host + ':' + port);
        this.log.info("Configured PrometheusPushGatewayReporter with {host:{}, port:{}, jobName:{}, randomJobNameSuffix:{}, deleteOnShutdown:{}, groupingKey:{}}", new Object[]{host, port, this.jobName, randomSuffix, this.deleteOnShutdown, this.groupingKey});
    }

    Map<String, String> parseGroupingKey(String groupingKeyConfig) {
        if (!groupingKeyConfig.isEmpty()) {
            String[] kvs;
            HashMap<String, String> groupingKey = new HashMap<String, String>();
            for (String kv : kvs = groupingKeyConfig.split(";")) {
                int idx = kv.indexOf("=");
                if (idx < 0) {
                    this.log.warn("Invalid prometheusPushGateway groupingKey:{}, will be ignored", (Object)kv);
                    continue;
                }
                String labelKey = kv.substring(0, idx);
                String labelValue = kv.substring(idx + 1);
                if (StringUtils.isNullOrWhitespaceOnly((String)labelKey) || StringUtils.isNullOrWhitespaceOnly((String)labelValue)) {
                    this.log.warn("Invalid groupingKey {labelKey:{}, labelValue:{}} must not be empty", (Object)labelKey, (Object)labelValue);
                    continue;
                }
                groupingKey.put(labelKey, labelValue);
            }
            return groupingKey;
        }
        return Collections.emptyMap();
    }

    public void report() {
        try {
            this.pushGateway.push(CollectorRegistry.defaultRegistry, this.jobName, this.groupingKey);
        }
        catch (Exception e) {
            this.log.warn("Failed to push metrics to PushGateway with jobName {}, groupingKey {}.", new Object[]{this.jobName, this.groupingKey, e});
        }
    }

    @Override
    public void close() {
        if (this.deleteOnShutdown && this.pushGateway != null) {
            try {
                this.pushGateway.delete(this.jobName, this.groupingKey);
            }
            catch (IOException e) {
                this.log.warn("Failed to delete metrics from PushGateway with jobName {}, groupingKey {}.", new Object[]{this.jobName, this.groupingKey, e});
            }
        }
        super.close();
    }
}

