/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.io.prometheus.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.shaded.io.prometheus.client.Collector;

public class SummaryMetricFamily
extends Collector.MetricFamilySamples {
    private final List<String> labelNames;
    private final List<Double> quantiles;

    public SummaryMetricFamily(String name, String help, double count, double sum) {
        super(name, Collector.Type.SUMMARY, help, new ArrayList<Collector.MetricFamilySamples.Sample>());
        this.labelNames = Collections.emptyList();
        this.quantiles = Collections.emptyList();
        this.addMetric(Collections.<String>emptyList(), count, sum);
    }

    public SummaryMetricFamily(String name, String help, List<String> labelNames) {
        this(name, help, labelNames, Collections.emptyList());
    }

    public SummaryMetricFamily(String name, String help, List<String> labelNames, List<Double> quantiles) {
        super(name, Collector.Type.SUMMARY, help, new ArrayList<Collector.MetricFamilySamples.Sample>());
        this.labelNames = labelNames;
        this.quantiles = quantiles;
    }

    public SummaryMetricFamily addMetric(List<String> labelValues, double count, double sum) {
        return this.addMetric(labelValues, count, sum, Collections.<Double>emptyList());
    }

    public SummaryMetricFamily addMetric(List<String> labelValues, double count, double sum, List<Double> quantiles) {
        if (labelValues.size() != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        if (this.quantiles.size() != quantiles.size()) {
            throw new IllegalArgumentException("Incorrect number of quantiles.");
        }
        this.samples.add(new Collector.MetricFamilySamples.Sample(this.name + "_count", this.labelNames, labelValues, count));
        this.samples.add(new Collector.MetricFamilySamples.Sample(this.name + "_sum", this.labelNames, labelValues, sum));
        ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(this.labelNames);
        labelNamesWithQuantile.add("quantile");
        for (int i = 0; i < quantiles.size(); ++i) {
            ArrayList<String> labelValuesWithQuantile = new ArrayList<String>(labelValues);
            labelValuesWithQuantile.add(Collector.doubleToGoString(this.quantiles.get(i)));
            this.samples.add(new Collector.MetricFamilySamples.Sample(this.name, labelNamesWithQuantile, labelValuesWithQuantile, quantiles.get(i)));
        }
        return this;
    }
}

