/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import java.time.Instant;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.influxdb.AbstractReporter;
import org.apache.flink.metrics.influxdb.InfluxdbReporterOptions;
import org.apache.flink.metrics.influxdb.MeasurementInfo;
import org.apache.flink.metrics.influxdb.MeasurementInfoProvider;
import org.apache.flink.metrics.influxdb.MetricMapper;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.InfluxDB;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.InfluxDBFactory;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.BatchPoints;
import org.apache.flink.metrics.reporter.Scheduled;

public class InfluxdbReporter
extends AbstractReporter<MeasurementInfo>
implements Scheduled {
    private String database;
    private InfluxDB influxDB;

    public InfluxdbReporter() {
        super(new MeasurementInfoProvider());
    }

    public void open(MetricConfig config) {
        String host = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.HOST);
        int port = InfluxdbReporterOptions.getInteger(config, InfluxdbReporterOptions.PORT);
        if (!InfluxdbReporter.isValidHost(host) || !InfluxdbReporter.isValidPort(port)) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        String database = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.DB);
        if (database == null) {
            throw new IllegalArgumentException("'" + InfluxdbReporterOptions.DB.key() + "' configuration option is not set");
        }
        String url = String.format("http://%s:%d", host, port);
        String username = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.USERNAME);
        String password = InfluxdbReporterOptions.getString(config, InfluxdbReporterOptions.PASSWORD);
        this.database = database;
        this.influxDB = username != null && password != null ? InfluxDBFactory.connect(url, username, password) : InfluxDBFactory.connect(url);
        this.log.info("Configured InfluxDBReporter with {host:{}, port:{}, db:{}}", new Object[]{host, port, database});
    }

    public void close() {
        if (this.influxDB != null) {
            this.influxDB.close();
            this.influxDB = null;
        }
    }

    public void report() {
        BatchPoints report = this.buildReport();
        if (report != null) {
            this.influxDB.write(report);
        }
    }

    @Nullable
    private BatchPoints buildReport() {
        Instant timestamp = Instant.now();
        BatchPoints.Builder report = BatchPoints.database(this.database);
        report.retentionPolicy("");
        try {
            for (Map.Entry entry : this.gauges.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Gauge)entry.getKey()));
            }
            for (Map.Entry entry : this.counters.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Counter)entry.getKey()));
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Histogram)entry.getKey()));
            }
            for (Map.Entry entry : this.meters.entrySet()) {
                report.point(MetricMapper.map((MeasurementInfo)entry.getValue(), timestamp, (Meter)entry.getKey()));
            }
        }
        catch (ConcurrentModificationException | NoSuchElementException e) {
            return null;
        }
        return report.build();
    }

    private static boolean isValidHost(String host) {
        return host != null && !host.isEmpty();
    }

    private static boolean isValidPort(int port) {
        return 0 < port && port <= 65535;
    }
}

