/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.influxdb.MeasurementInfo;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.Point;

class MetricMapper {
    MetricMapper() {
    }

    static Point map(MeasurementInfo info, Instant timestamp, Gauge<?> gauge) {
        Point.Builder builder = MetricMapper.builder(info, timestamp);
        Object value = gauge.getValue();
        if (value instanceof Number) {
            builder.addField("value", (Number)value);
        } else {
            builder.addField("value", String.valueOf(value));
        }
        return builder.build();
    }

    static Point map(MeasurementInfo info, Instant timestamp, Counter counter) {
        return MetricMapper.builder(info, timestamp).addField("count", counter.getCount()).build();
    }

    static Point map(MeasurementInfo info, Instant timestamp, Histogram histogram) {
        HistogramStatistics statistics = histogram.getStatistics();
        return MetricMapper.builder(info, timestamp).addField("count", statistics.size()).addField("min", statistics.getMin()).addField("max", statistics.getMax()).addField("mean", statistics.getMean()).addField("stddev", statistics.getStdDev()).addField("p50", statistics.getQuantile(0.5)).addField("p75", statistics.getQuantile(0.75)).addField("p95", statistics.getQuantile(0.95)).addField("p98", statistics.getQuantile(0.98)).addField("p99", statistics.getQuantile(0.99)).addField("p999", statistics.getQuantile(0.999)).build();
    }

    static Point map(MeasurementInfo info, Instant timestamp, Meter meter) {
        return MetricMapper.builder(info, timestamp).addField("count", meter.getCount()).addField("rate", meter.getRate()).build();
    }

    private static Point.Builder builder(MeasurementInfo info, Instant timestamp) {
        return Point.measurement(info.getName()).tag(info.getTags()).time(timestamp.toEpochMilli(), TimeUnit.MILLISECONDS);
    }
}

