/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.influxdb.MetricInfoProvider;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReporter<MetricInfo>
implements MetricReporter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Map<Gauge<?>, MetricInfo> gauges = new HashMap();
    protected final Map<Counter, MetricInfo> counters = new HashMap<Counter, MetricInfo>();
    protected final Map<Histogram, MetricInfo> histograms = new HashMap<Histogram, MetricInfo>();
    protected final Map<Meter, MetricInfo> meters = new HashMap<Meter, MetricInfo>();
    protected final MetricInfoProvider<MetricInfo> metricInfoProvider;

    protected AbstractReporter(MetricInfoProvider<MetricInfo> metricInfoProvider) {
        this.metricInfoProvider = metricInfoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        MetricInfo metricInfo = this.metricInfoProvider.getMetricInfo(metricName, group);
        AbstractReporter abstractReporter = this;
        synchronized (abstractReporter) {
            if (metric instanceof Counter) {
                this.counters.put((Counter)metric, metricInfo);
            } else if (metric instanceof Gauge) {
                this.gauges.put((Gauge)metric, metricInfo);
            } else if (metric instanceof Histogram) {
                this.histograms.put((Histogram)metric, metricInfo);
            } else if (metric instanceof Meter) {
                this.meters.put((Meter)metric, metricInfo);
            } else {
                this.log.warn("Cannot add unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        AbstractReporter abstractReporter = this;
        synchronized (abstractReporter) {
            if (metric instanceof Counter) {
                this.counters.remove(metric);
            } else if (metric instanceof Gauge) {
                this.gauges.remove(metric);
            } else if (metric instanceof Histogram) {
                this.histograms.remove(metric);
            } else if (metric instanceof Meter) {
                this.meters.remove(metric);
            } else {
                this.log.warn("Cannot remove unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
    }
}

