/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.retrofit2.converter.moshi;

import java.io.IOException;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonWriter;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.MediaType;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.RequestBody;
import org.apache.flink.metrics.influxdb.shaded.okio.Buffer;
import org.apache.flink.metrics.influxdb.shaded.retrofit2.Converter;

final class MoshiRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.get("application/json; charset=UTF-8");
    private final JsonAdapter<T> adapter;

    MoshiRequestBodyConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
    }

    @Override
    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter writer = JsonWriter.of(buffer);
        this.adapter.toJson(writer, value);
        return RequestBody.create(MEDIA_TYPE, buffer.readByteString());
    }
}

