/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.retrofit2;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.metrics.influxdb.shaded.retrofit2.Utils;

public final class Invocation {
    private final Method method;
    private final List<?> arguments;

    public static Invocation of(Method method, List<?> arguments) {
        Utils.checkNotNull(method, "method == null");
        Utils.checkNotNull(arguments, "arguments == null");
        return new Invocation(method, new ArrayList(arguments));
    }

    Invocation(Method method, List<?> arguments) {
        this.method = method;
        this.arguments = Collections.unmodifiableList(arguments);
    }

    public Method method() {
        return this.method;
    }

    public List<?> arguments() {
        return this.arguments;
    }

    public String toString() {
        return String.format("%s.%s() %s", this.method.getDeclaringClass().getName(), this.method.getName(), this.arguments);
    }
}

