/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Alias;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Appendable;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Column;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Distinct;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Function;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.ConjunctionClause;

public final class Appender {
    private static final Pattern COLUMN_NAME_PATTERN = Pattern.compile("\\w+(?:\\[.+\\])?");

    private Appender() {
    }

    public static StringBuilder joinAndAppend(StringBuilder stringBuilder, List<? extends ConjunctionClause> clauses) {
        for (int i = 0; i < clauses.size(); ++i) {
            if (i > 0) {
                clauses.get(i).join(stringBuilder);
            }
            clauses.get(i).appendTo(stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder joinAndAppend(StringBuilder stringBuilder, String separator, List<? extends Appendable> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(separator);
            }
            values.get(i).appendTo(stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder joinAndAppendNames(StringBuilder stringBuilder, List<?> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            Appender.appendName(values.get(i), stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder appendValue(Object value, StringBuilder stringBuilder) {
        if (value instanceof Appendable) {
            Appendable appendable = (Appendable)value;
            appendable.appendTo(stringBuilder);
        } else if (value instanceof Function) {
            Function functionCall = (Function)value;
            stringBuilder.append(functionCall.getName()).append('(');
            for (int i = 0; i < functionCall.getParameters().length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                Appender.appendValue(functionCall.getParameters()[i], stringBuilder);
            }
            stringBuilder.append(')');
        } else if (value instanceof Column) {
            Appender.appendName(((Column)value).getName(), stringBuilder);
        } else if (value instanceof String) {
            stringBuilder.append("'").append(value).append("'");
        } else if (value != null) {
            stringBuilder.append(value);
        } else {
            stringBuilder.append('?');
            return stringBuilder;
        }
        return stringBuilder;
    }

    public static StringBuilder appendName(String name, StringBuilder stringBuilder) {
        String trimmedName = name.trim();
        if (trimmedName.startsWith("\"") || COLUMN_NAME_PATTERN.matcher(trimmedName).matches()) {
            stringBuilder.append(trimmedName);
        } else {
            stringBuilder.append('\"').append(trimmedName).append('\"');
        }
        return stringBuilder;
    }

    public static StringBuilder appendName(Object name, StringBuilder stringBuilder) {
        if (name instanceof String) {
            Appender.appendName((String)name, stringBuilder);
        } else if (name instanceof Column) {
            Appender.appendName(((Column)name).getName(), stringBuilder);
        } else if (name instanceof Function) {
            Function functionCall = (Function)name;
            stringBuilder.append(functionCall.getName()).append('(');
            for (int i = 0; i < functionCall.getParameters().length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                Appender.appendValue(functionCall.getParameters()[i], stringBuilder);
            }
            stringBuilder.append(')');
        } else if (name instanceof Alias) {
            Alias alias = (Alias)name;
            Appender.appendName(alias.getColumn(), stringBuilder);
            stringBuilder.append(" AS ").append(alias.getAlias());
        } else if (name instanceof Distinct) {
            Distinct distinct = (Distinct)name;
            stringBuilder.append("DISTINCT ");
            Appender.appendName(distinct.getExpression(), stringBuilder);
        } else if (name instanceof Appendable) {
            Appendable appendable = (Appendable)name;
            appendable.appendTo(stringBuilder);
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
        return stringBuilder;
    }
}

