/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.retrofit2.converter.moshi;

import java.io.IOException;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonDataException;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonReader;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.ResponseBody;
import org.apache.flink.metrics.influxdb.shaded.okio.BufferedSource;
import org.apache.flink.metrics.influxdb.shaded.okio.ByteString;
import org.apache.flink.metrics.influxdb.shaded.retrofit2.Converter;

final class MoshiResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final ByteString UTF8_BOM = ByteString.decodeHex("EFBBBF");
    private final JsonAdapter<T> adapter;

    MoshiResponseBodyConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(ResponseBody value) throws IOException {
        BufferedSource source = value.source();
        try {
            if (source.rangeEquals(0L, UTF8_BOM)) {
                source.skip(UTF8_BOM.size());
            }
            JsonReader reader = JsonReader.of(source);
            T result = this.adapter.fromJson(reader);
            if (reader.peek() != JsonReader.Token.END_DOCUMENT) {
                throw new JsonDataException("JSON document was not fully consumed.");
            }
            T t = result;
            return t;
        }
        finally {
            value.close();
        }
    }
}

